DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -3.52151091401099E-12   0.00000000000000E+00  -7.63373197568178E-10   1.59629341615396E-22
      4.28496253621525E-09   3.52158933864723E-09  -7.94952621556921E-19  -2.47846792153655E-01  -2.47846792161902E-01
      0.00000000000000E+00   0.00000000000000E+00   8.24663290355711E-09   0.00000000000000E+00   8.24663290355711E-09
      3.70485193211918E-18  -2.47846792153655E-01  -2.44139204126639E-01   0.00000000000000E+00   2.44091921865944E-11
     -9.83204380319236E-23  -1.17926314343938E-08  -1.17682222422073E-08  -2.90989931056225E-18
      1.17500000000000E-12
      0.00000000000000E+00  -3.54245151409431E-12   0.00000000000000E+00  -5.10456624970707E-11   1.52004576583291E-22
      3.59345855806686E-09   3.54241289556994E-09  -7.99779131575748E-19  -2.45758708979509E-01  -2.45758708987284E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77521311473881E-09   0.00000000000000E+00   7.77521311473881E-09
      3.71010020097163E-18  -2.45758708979508E-01  -2.42193067398457E-01   0.00000000000000E+00   3.28865241608372E-11
     -9.82940725672038E-23  -1.13505125344693E-08  -1.13176260103085E-08  -2.91032106939588E-18
      1.63062500000000E-12
      0.00000000000000E+00  -3.55549346677778E-12   0.00000000000000E+00  -4.01579895894217E-12   1.46010493403267E-22
      3.55948600423014E-09   3.55547020527135E-09  -8.02853241040652E-19  -2.44452979472818E-01  -2.44452979480242E-01
      0.00000000000000E+00   0.00000000000000E+00   7.42462877088651E-09   0.00000000000000E+00   7.42462877088651E-09
      3.71348304745536E-18  -2.44452979472817E-01  -2.40993677520441E-01   0.00000000000000E+00   3.60857367449184E-11
     -9.82760747166170E-23  -1.10161847128967E-08  -1.09800989761519E-08  -2.91062980641471E-18
      2.24571875000000E-12
      0.00000000000000E+00  -3.57184183000072E-12   0.00000000000000E+00   6.59592507944908E-13   1.37576381171113E-22
      3.57118559781410E-09   3.57184519032218E-09  -8.06706042853565E-19  -2.42815955710230E-01  -2.42815955717168E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93804596275863E-09   0.00000000000000E+00   6.93804596275863E-09
      3.71775059616427E-18  -2.42815955710230E-01  -2.39504795656913E-01   0.00000000000000E+00   3.69561031074675E-11
     -9.82529838228843E-23  -1.05468472561915E-08  -1.05098911530841E-08  -2.91104455331070E-18
      3.07609531250000E-12
      0.00000000000000E+00  -3.59195582744916E-12   0.00000000000000E+00   9.37089423705051E-13   1.26894946454609E-22
      3.59107293422003E-09   3.59201002364386E-09  -8.11436679895857E-19  -2.40800255159454E-01  -2.40800255165772E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31788741015627E-09   0.00000000000000E+00   6.31788741015627E-09
      3.72299682179417E-18  -2.40800255159455E-01  -2.37678126630237E-01   0.00000000000000E+00   3.48666247878893E-11
     -9.82249396915614E-23  -9.94476405858783E-09  -9.90989743380005E-09  -2.91156014189832E-18
      4.19710367187500E-12
      0.00000000000000E+00  -3.61620283807195E-12   0.00000000000000E+00   8.68596509131057E-13   1.14456091951263E-22
      3.61537908722835E-09   3.61624768373759E-09  -8.17101668032616E-19  -2.38378189372834E-01  -2.38378189378422E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58781989012633E-09   0.00000000000000E+00   5.58781989012633E-09
      3.72926081460169E-18  -2.38378189372838E-01  -2.35478438652251E-01   0.00000000000000E+00   3.04549794961414E-11
     -9.81923041473315E-23  -9.23452255336039E-09  -9.20406757386435E-09  -2.91215914656907E-18
      5.71046495703125E-12
      0.00000000000000E+00  -3.64449101713187E-12   0.00000000000000E+00   7.86260580800596E-13   1.00902700181537E-22
      3.64375710409695E-09   3.64454336467785E-09  -8.23686434897771E-19  -2.35551938020390E-01  -2.35551938025175E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78528303513439E-09   0.00000000000000E+00   4.78528303513439E-09
      3.73650267668557E-18  -2.35551938020394E-01  -2.32896123079448E-01   0.00000000000000E+00   2.48734346617308E-11
     -9.81556867311480E-23  -8.45469983447333E-09  -8.42982639981169E-09  -2.91281624178780E-18
      7.75350269199219E-12
      0.00000000000000E+00  -3.67636114094288E-12   0.00000000000000E+00   7.21475773796861E-13   8.69457917302940E-23
      3.67574073686223E-09   3.67646221263612E-09  -8.31077810893656E-19  -2.32365739487359E-01  -2.32365739491314E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95445176751688E-09   0.00000000000000E+00   3.95445176751688E-09
      3.74458177086769E-18  -2.32365739487353E-01  -2.29961640487153E-01   0.00000000000000E+00   1.91337702727310E-11
     -9.81161074529618E-23  -7.65004775042496E-09  -7.63091398015233E-09  -2.91350395997404E-18
      1.05116036341895E-11
      0.00000000000000E+00  -3.71080291739570E-12   0.00000000000000E+00   6.84831674535985E-13   7.33096299329698E-23
      3.71036804431681E-09   3.71105287599142E-09  -8.39045543359321E-19  -2.28915116591937E-01  -2.28915116595078E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14087052240846E-09   0.00000000000000E+00   3.14087052240846E-09
      3.75324460881487E-18  -2.28915116591932E-01  -2.26756465907689E-01   0.00000000000000E+00   1.38931441866446E-11
     -9.80750084462066E-23  -6.86581654258674E-09  -6.85192339840020E-09  -2.91419906545555E-18
      1.42350399061558E-11
      0.00000000000000E+00  -3.74643867543222E-12   0.00000000000000E+00   6.77315208596214E-13   6.06695687867288E-23
      3.74614472034066E-09   3.74682203554932E-09  -8.47241695962977E-19  -2.25348878470469E-01  -2.25348878472855E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38661385803357E-09   0.00000000000000E+00   2.38661385803357E-09
      3.76213101342105E-18  -2.25348878470461E-01  -2.23416621691356E-01   0.00000000000000E+00   9.49303894432934E-12
     -9.80341119764983E-23  -6.14292893252715E-09  -6.13343589358292E-09  -2.91488931745807E-18
      1.92616788733103E-11
      0.00000000000000E+00  -3.78143152030829E-12   0.00000000000000E+00   2.64572602336822E-13   4.95826342848442E-23
      3.78113982656991E-09   3.78140439917229E-09  -8.55226480720708E-19  -2.21859559985419E-01  -2.21859559987145E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72578446149097E-09   0.00000000000000E+00   1.72578446149097E-09
      3.77080590884409E-18  -2.21859559985404E-01  -2.20124505178231E-01   0.00000000000000E+00   6.47413893381566E-12
     -9.79952576105954E-23  -5.51366299959691E-09  -5.50718886066320E-09  -2.91557942812338E-18
      2.60476414789689E-11
      0.00000000000000E+00  -3.81339348885651E-12   0.00000000000000E+00   1.79139218784743E-13   4.04418383647442E-23
      3.81321398404403E-09   3.81339312326285E-09  -8.62522110948256E-19  -2.18660687563429E-01  -2.18660687564609E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18062220462877E-09   0.00000000000000E+00   1.18062220462877E-09
      3.77881756697611E-18  -2.18660687563409E-01  -2.17087308775616E-01   0.00000000000000E+00   4.05570452552100E-12
     -9.79598060809156E-23  -4.99807103241705E-09  -4.99401532789163E-09  -2.91629545602785E-18
      3.52086909966080E-11
      0.00000000000000E+00  -3.84048768633273E-12   0.00000000000000E+00   1.12461581966165E-13   3.34419034110349E-23
      3.84041500346544E-09   3.84052746504743E-09  -8.68701300030915E-19  -2.15947253417727E-01  -2.15947253418488E-01
      0.00000000000000E+00   0.00000000000000E+00   7.60671285364917E-10   0.00000000000000E+00   7.60671285364917E-10
      3.78578611428798E-18  -2.15947253417691E-01  -2.14497632068302E-01   0.00000000000000E+00   2.40587066736033E-12
     -9.79287249158398E-23  -4.60360462107954E-09  -4.60119875041228E-09  -2.91708481425707E-18
      4.75761078454208E-11
      0.00000000000000E+00  -3.86152013115325E-12   0.00000000000000E+00   6.46655405813173E-14   2.85753168880381E-23
      3.86145944734024E-09   3.86152411288085E-09  -8.73491195858659E-19  -2.13847588728176E-01  -2.13847588728639E-01
      0.00000000000000E+00   0.00000000000000E+00   4.62548650483433E-10   0.00000000000000E+00   4.62548650483433E-10
      3.79150664626137E-18  -2.13847588728161E-01  -2.12485276343828E-01   0.00000000000000E+00   1.35407327577322E-12
     -9.79020602744963E-23  -4.32542683663993E-09  -4.32407276336425E-09  -2.91801545040271E-18
      6.42721205913181E-11
      0.00000000000000E+00  -3.87621528910646E-12   0.00000000000000E+00   3.38159020281900E-14   2.56389556855064E-23
      3.87614690444343E-09   3.87618072034548E-09  -8.76860350078939E-19  -2.12381928031922E-01  -2.12381928032193E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71226427539129E-10   0.00000000000000E+00   2.71226427539129E-10
      3.79603504615259E-18  -2.12381928031914E-01  -2.11075274415376E-01   0.00000000000000E+00   7.34702207299420E-13
     -9.78787909902501E-23  -4.14814185009182E-09  -4.14740714788462E-09  -2.91917469607365E-18
      8.68117377982794E-11
      0.00000000000000E+00  -3.88549160756442E-12   0.00000000000000E+00   2.30063252844878E-13   2.42743856969313E-23
      3.88544492046211E-09   3.88567498371498E-09  -8.79032908742756E-19  -2.11453875673751E-01  -2.11453875673914E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62755968124146E-10   0.00000000000000E+00   1.62755968124146E-10
      3.79970350337225E-18  -2.11453875673477E-01  -2.10178471973153E-01   0.00000000000000E+00   1.90759730456430E-13
     -9.78568004665583E-23  -4.04862171156949E-09  -4.04843095183913E-09  -2.92067059462950E-18
      1.17240221027677E-10
      0.00000000000000E+00  -3.89109413653408E-12   0.00000000000000E+00   9.91905790899779E-14   2.40522221801732E-23
      3.89111902205315E-09   3.89121821263226E-09  -8.80403680646146E-19  -2.10887313073567E-01  -2.10887313073677E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09633952877018E-10   0.00000000000000E+00   1.09633952877018E-10
      3.80303949826875E-18  -2.10887313073470E-01  -2.09626860534960E-01   0.00000000000000E+00   1.57530211127158E-13
     -9.78333976750491E-23  -4.00100969572030E-09  -4.00085216550927E-09  -2.92263581762260E-18
      1.58318673387364E-10
      0.00000000000000E+00  -3.89504346023400E-12   0.00000000000000E+00   3.17048754583852E-14   2.45998392991160E-23
      3.89501836098530E-09   3.89505006586078E-09  -8.81377204726295E-19  -2.10497725541598E-01  -2.10497725541685E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69674038553796E-11   0.00000000000000E+00   8.69674038553796E-11
      3.80661198462486E-18  -2.10497725540724E-01  -2.09243186659297E-01   0.00000000000000E+00   1.57325406639191E-13
     -9.78053851957950E-23  -3.98217479512268E-09  -3.98201746971614E-09  -2.92523477989857E-18
      2.08318673387364E-10
      0.00000000000000E+00  -3.89825802603627E-12   0.00000000000000E+00   7.51414099451226E-15   2.55744649305665E-23
      3.89825197703381E-09   3.89825949117483E-09  -8.82177614386878E-19  -2.10174481970937E-01  -2.10174481971015E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80785498507396E-11   0.00000000000000E+00   7.80785498507396E-11
      3.81051591211740E-18  -2.10174481968157E-01  -2.08921725060000E-01   0.00000000000000E+00   1.56482629689657E-13
     -9.77731027979869E-23  -3.97649452365513E-09  -3.97633804102554E-09  -2.92833829773052E-18
      2.58318673387364E-10
      0.00000000000000E+00  -3.90101336815249E-12   0.00000000000000E+00   3.15219738904597E-15   2.66161651516485E-23
      3.90102617912391E-09   3.90102933132133E-09  -8.82834609316034E-19  -2.09897100649206E-01  -2.09897100649280E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41388981980995E-11   0.00000000000000E+00   7.41388981980995E-11
      3.81422285702731E-18  -2.09897100643700E-01  -2.08644710946142E-01   0.00000000000000E+00   1.50978069437756E-13
     -9.77417142408125E-23  -3.97531920758880E-09  -3.97516822951946E-09  -2.93138824771127E-18
      3.08318673387364E-10
      0.00000000000000E+00  -3.90358502079430E-12   0.00000000000000E+00   2.94095943304115E-15   2.76632211580309E-23
      3.90361867569711E-09   3.90362161665657E-09  -8.83415174746610E-19  -2.09637868287397E-01  -2.09637868287469E-01
      0.00000000000000E+00   0.00000000000000E+00   7.15937691461570E-11   0.00000000000000E+00   7.15937691461570E-11
      3.81780254548461E-18  -2.09637868277342E-01  -2.08385463625838E-01   0.00000000000000E+00   1.45655513795290E-13
     -9.77109584257463E-23  -3.97536104131643E-09  -3.97521538580273E-09  -2.93438737073800E-18
      3.58318673387364E-10
      0.00000000000000E+00  -3.90606482869891E-12   0.00000000000000E+00   2.57880178094076E-15   2.87002903136647E-23
      3.90610589110758E-09   3.90610846990939E-09  -8.83940731026846E-19  -2.09389158833375E-01  -2.09389158833445E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95105737248987E-11   0.00000000000000E+00   6.95105737248987E-11
      3.82127807417086E-18  -2.09389158820089E-01  -2.08136626833636E-01   0.00000000000000E+00   1.41940502963070E-13
     -9.76807436883397E-23  -3.97576098413716E-09  -3.97561904363429E-09  -2.93733734314401E-18
      4.08318673387364E-10
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   1.70228377676203E-15   2.97241356993292E-23
      3.90851155861432E-09   3.90851326089813E-09  -8.84420463057942E-19  -2.09148600903738E-01  -2.09148600903806E-01
      0.00000000000000E+00   0.00000000000000E+00   6.76368205753888E-11   0.00000000000000E+00   6.76368205753888E-11
      3.82465991519963E-18  -2.09148600888198E-01  -2.07895901268569E-01   0.00000000000000E+00   1.39364294655257E-13
     -9.76510385468436E-23  -3.97628944576809E-09  -3.97615008147353E-09  -2.94023945214169E-18
      4.58318673387364E-10
      0.00000000000000E+00  -3.91084075503370E-12   0.00000000000000E+00   2.14151183100779E-15   3.07345338224541E-23
      3.91084541909670E-09   3.91084756060856E-09  -8.84860011659572E-19  -2.08915224052628E-01  -2.08915224052694E-01
      0.00000000000000E+00   0.00000000000000E+00   6.58978497163823E-11   0.00000000000000E+00   6.58978497163823E-11
      3.82795480768545E-18  -2.08915224039594E-01  -2.07662336945035E-01   0.00000000000000E+00   1.35843295292677E-13
     -9.76218089106937E-23  -3.97688125362013E-09  -3.97674541032493E-09  -2.94309479602588E-18
      5.08318673387364E-10
      0.00000000000000E+00  -3.91313687346389E-12   0.00000000000000E+00   1.73308878214815E-15   3.17320262848752E-23
      3.91311319085494E-09   3.91311492394375E-09  -8.85263768891122E-19  -2.08688454070266E-01  -2.08688454070330E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42664154339251E-11   0.00000000000000E+00   6.42664154339251E-11
      3.83116812845714E-18  -2.08688454068329E-01  -2.07435366439577E-01   0.00000000000000E+00   1.33420706128302E-13
     -9.75930424186396E-23  -3.97751476008373E-09  -3.97738133937770E-09  -2.94590435956602E-18
      5.58318673387364E-10
      0.00000000000000E+00  -3.91534114715687E-12   0.00000000000000E+00   2.04174985725366E-15   3.27172404199449E-23
      3.91531931088717E-09   3.91532135263706E-09  -8.85635500137417E-19  -2.08467849657909E-01  -2.08467849657972E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27283900598512E-11   0.00000000000000E+00   6.27283900598512E-11
      3.83430454796014E-18  -2.08467849677589E-01  -2.07214551509470E-01   0.00000000000000E+00   1.30479951578800E-13
     -9.75647188006243E-23  -3.97818022264837E-09  -3.97804974269689E-09  -2.94866904782272E-18
      6.08318673387364E-10
      0.00000000000000E+00  -3.91745357611264E-12   0.00000000000000E+00   1.78835841020362E-15   3.36908010422444E-23
      3.91746754200084E-09   3.91746933035929E-09  -8.85978534382888E-19  -2.08253032652039E-01  -2.08253032652100E-01
      0.00000000000000E+00   0.00000000000000E+00   6.12738976597783E-11   0.00000000000000E+00   6.12738976597783E-11
      3.83736824284312E-18  -2.08253032701893E-01  -2.06999515914651E-01   0.00000000000000E+00   1.28255401881220E-13
     -9.75368262662364E-23  -3.97887148342087E-09  -3.97874322801908E-09  -2.95138970846024E-18
      6.58318673387364E-10
      0.00000000000000E+00  -3.91947416033120E-12   0.00000000000000E+00  -1.49951801150407E-16   3.46532632105380E-23
      3.91956128290700E-09   3.91956113295524E-09  -8.86295844453444E-19  -2.08043664219894E-01  -2.08043664219954E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98949253054885E-11   0.00000000000000E+00   5.98949253054885E-11
      3.84036298910840E-18  -2.08043664303353E-01  -2.06789922271628E-01   0.00000000000000E+00   1.27834496601121E-13
     -9.75093517342648E-23  -3.97958389275720E-09  -3.97945605826070E-09  -2.95406714465495E-18
      7.08318673387364E-10
      0.00000000000000E+00  -3.92158658928698E-12   0.00000000000000E+00   1.79309718514919E-15   3.56051002228314E-23
      3.92160359490987E-09   3.92160538800709E-09  -8.86590082091906E-19  -2.07839439895118E-01  -2.07839439895176E-01
      0.00000000000000E+00   0.00000000000000E+00   5.85843526472799E-11   0.00000000000000E+00   5.85843526472799E-11
      3.84329220674076E-18  -2.07839439997202E-01  -2.06585467374732E-01   0.00000000000000E+00   1.23659985152980E-13
     -9.74822842001569E-23  -3.98031340063946E-09  -3.98018974065441E-09  -2.95670212464886E-18
      7.58318673387364E-10
      0.00000000000000E+00  -3.92360717350554E-12   0.00000000000000E+00   5.83131891406574E-16   3.65467798624764E-23
      3.92359723147436E-09   3.92359781460629E-09  -8.86863627400635E-19  -2.07640081366402E-01  -2.07640081366459E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73362318462296E-11   0.00000000000000E+00   5.73362318462296E-11
      3.84615901833307E-18  -2.07640081451814E-01  -2.06385873897092E-01   0.00000000000000E+00   1.22714472475739E-13
     -9.74556136415514E-23  -3.98105676092488E-09  -3.98093404645250E-09  -2.95929539093244E-18
      8.08318673387364E-10
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00   1.76748669612914E-15   3.74786659830352E-23
      3.92554474073021E-09   3.92554650821694E-09  -8.87118600526878E-19  -2.07445336939761E-01  -2.07445336939817E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61448886365145E-11   0.00000000000000E+00   5.61448886365145E-11
      3.84896626276490E-18  -2.07445336951595E-01  -2.06190891110374E-01   0.00000000000000E+00   1.19467456493894E-13
     -9.74293305704923E-23  -3.98181086430984E-09  -3.98169139685345E-09  -2.96184766223802E-18
      8.58318673387364E-10
      0.00000000000000E+00  -3.92746465246826E-12   0.00000000000000E+00   1.01850092739723E-15   3.84011256569359E-23
      3.92744840401133E-09   3.92744942251229E-09  -8.87356902319617E-19  -2.07254976014973E-01  -2.07254976015028E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50055982224276E-11   0.00000000000000E+00   5.50055982224276E-11
      3.85171654267602E-18  -2.07254975878008E-01  -2.06000289163966E-01   0.00000000000000E+00   1.18209418351930E-13
     -9.74034264621553E-23  -3.98257323015294E-09  -3.98245502073468E-09  -2.96435964035640E-18
      9.08318673387364E-10
      0.00000000000000E+00  -3.92930154721241E-12   0.00000000000000E+00   1.72372747140435E-15   3.93144476431255E-23
      3.92931033563009E-09   3.92931205935760E-09  -8.87580225761370E-19  -2.07068789135638E-01  -2.07068789135692E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39138570470965E-11   0.00000000000000E+00   5.39138570470965E-11
      3.85441223552838E-18  -2.07068788789619E-01  -2.05813859370897E-01   0.00000000000000E+00   1.15570596668574E-13
     -9.73778931319808E-23  -3.98334148700131E-09  -3.98322591640473E-09  -2.96683200976701E-18
      9.58318673387365E-10
      0.00000000000000E+00  -3.93113844195656E-12   0.00000000000000E+00   1.26529641036066E-15   4.02189209320891E-23
      3.93113243234818E-09   3.93113369764463E-09  -8.87790086896817E-19  -2.06886583902983E-01  -2.06886583903036E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28658752981544E-11   0.00000000000000E+00   5.28658752981544E-11
      3.85705552929328E-18  -2.06886583343079E-01  -2.05631409982845E-01   0.00000000000000E+00   1.14138384470189E-13
     -9.73527231867546E-23  -3.98411371132714E-09  -3.98399957294277E-09  -2.96926544239647E-18
      1.00831867338736E-09
      0.00000000000000E+00  -3.93288349196350E-12   0.00000000000000E+00   1.67056332036570E-15   4.11147755263084E-23
      3.93291646313700E-09   3.93291813370036E-09  -8.87987835654621E-19  -2.06708184904229E-01  -2.06708184904281E-01
      0.00000000000000E+00   0.00000000000000E+00   5.18580514965237E-11   0.00000000000000E+00   5.18580514965237E-11
      3.85964843186811E-18  -2.06708184231846E-01  -2.05452766271891E-01   0.00000000000000E+00   1.11903325404540E-13
     -9.73279092841185E-23  -3.98488808852221E-09  -3.98477618519690E-09  -2.97166059621349E-18
      1.05831867338736E-09
      0.00000000000000E+00  -3.93462854197045E-12   0.00000000000000E+00   1.39363305117582E-15   4.20022398944754E-23
      3.93466401416357E-09   3.93466540779666E-09  -8.88174679785020E-19  -2.06533430531329E-01  -2.06533430531380E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08873336078814E-11   0.00000000000000E+00   5.08873336078814E-11
      3.86219279854850E-18  -2.06533429997011E-01  -2.05277767239903E-01   0.00000000000000E+00   1.10385233847422E-13
     -9.73034448629129E-23  -3.98566312663829E-09  -3.98555274140454E-09  -2.97401811876348E-18
      1.10831867338736E-09
      0.00000000000000E+00  -3.93637359197739E-12   0.00000000000000E+00   1.61337474256367E-15   4.28814978208937E-23
      3.93637658612879E-09   3.93637819950358E-09  -8.88351694394062E-19  -2.06362172933430E-01  -2.06362172933480E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99508198232316E-11   0.00000000000000E+00   4.99508198232316E-11
      3.86469033953967E-18  -2.06362172933580E-01  -2.05106265624302E-01   0.00000000000000E+00   1.08422773180930E-13
     -9.72793233725576E-23  -3.98643744209991E-09  -3.98632901932683E-09  -2.97633864514560E-18
      1.15831867338736E-09
      0.00000000000000E+00  -3.93802679724712E-12   0.00000000000000E+00   1.44878252037955E-15   4.37527308464906E-23
      3.93805552311820E-09   3.93805697190076E-09  -8.88519840705562E-19  -2.06194275449299E-01  -2.06194275449348E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90460400225989E-11   0.00000000000000E+00   4.90460400225989E-11
      3.86714264154079E-18  -2.06194276451380E-01  -2.04938125188854E-01   0.00000000000000E+00   1.06874032110854E-13
     -9.72555388932469E-23  -3.98720988595535E-09  -3.98710301192334E-09  -2.97862280083524E-18
      1.20831867338736E-09
      0.00000000000000E+00  -3.93968000251686E-12   0.00000000000000E+00   1.55538672017631E-15   4.46160868372333E-23
      3.93970212650444E-09   3.93970368189120E-09  -8.88679974018038E-19  -2.06029612671582E-01  -2.06029612671630E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81706368843865E-11   0.00000000000000E+00   4.81706368843865E-11
      3.86955117338501E-18  -2.06029615028816E-01  -2.04773220745429E-01   0.00000000000000E+00   1.05100414540277E-13
     -9.72320854402120E-23  -3.98797941919004E-09  -3.98787431877560E-09  -2.98087119936698E-18
      1.25831867338736E-09
      0.00000000000000E+00  -3.94133320778660E-12   0.00000000000000E+00   1.45956201611430E-15   4.54717112724617E-23
      3.94131756691301E-09   3.94131902647507E-09  -8.88832858548620E-19  -2.05868068324050E-01  -2.05868068324097E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73225981400457E-11   0.00000000000000E+00   4.73225981400457E-11
      3.87191730329202E-18  -2.05868072000168E-01  -2.04611435892797E-01   0.00000000000000E+00   1.03555088395046E-13
     -9.72089575623927E-23  -3.98874517970345E-09  -3.98864162461515E-09  -2.98308444474340E-18
      1.30831867338736E-09
      0.00000000000000E+00  -3.94298641305633E-12   0.00000000000000E+00   1.49850155072177E-15   4.63197239564125E-23
      3.94290298259057E-09   3.94290448109217E-09  -8.88979174257541E-19  -2.05709535257175E-01  -2.05709535257222E-01
      0.00000000000000E+00   0.00000000000000E+00   4.65000037749766E-11   0.00000000000000E+00   4.65000037749766E-11
      3.87424230348077E-18  -2.05709539499984E-01  -2.04452663012454E-01   0.00000000000000E+00   1.01917019553135E-13
     -9.71861496991125E-23  -3.98950640188658E-09  -3.98940448486713E-09  -2.98526312922323E-18
      1.35831867338736E-09
      0.00000000000000E+00  -3.94445592885165E-12   0.00000000000000E+00   1.44409524704878E-15   4.71602422424463E-23
      3.94445939788389E-09   3.94446084197918E-09  -8.89119528556957E-19  -2.05553913714360E-01  -2.05553913714406E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57012175904527E-11   0.00000000000000E+00   4.57012175904527E-11
      3.87652736436029E-18  -2.05553916826211E-01  -2.04296801594554E-01   0.00000000000000E+00   1.00395690851461E-13
     -9.71636567708846E-23  -3.99026245526038E-09  -3.99016205956962E-09  -2.98740783580333E-18
      1.40831867338736E-09
      0.00000000000000E+00  -3.94601728938418E-12   0.00000000000000E+00   1.44367144758432E-15   4.79933632102121E-23
      3.94598777739053E-09   3.94598922106203E-09  -8.89254462472163E-19  -2.05401111094179E-01  -2.05401111094224E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49246961977677E-11   0.00000000000000E+00   4.49246961977677E-11
      3.87877359917018E-18  -2.05401110486254E-01  -2.04143758329404E-01   0.00000000000000E+00   9.88588562417448E-14
     -9.71414736158796E-23  -3.99101277611596E-09  -3.99091391725981E-09  -2.98951913669802E-18
      1.45831867338736E-09
      0.00000000000000E+00  -3.94748680517950E-12   0.00000000000000E+00   1.41356393606293E-15   4.88191806590197E-23
      3.94748893451119E-09   3.94749034807517E-09  -8.89384460265858E-19  -2.05251040356749E-01  -2.05251040356793E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41691507692535E-11   0.00000000000000E+00   4.41691507692535E-11
      3.88098205670864E-18  -2.05251033109751E-01  -2.03993445995963E-01   0.00000000000000E+00   9.73726806877737E-14
     -9.71195955309408E-23  -3.99175687152501E-09  -3.99165949884442E-09  -2.99159759644278E-18
      1.50831867338736E-09
      0.00000000000000E+00  -3.94904816571203E-12   0.00000000000000E+00   1.39102641345516E-15   4.96377712850758E-23
      3.94896357227137E-09   3.94896496329783E-09  -8.89509954797324E-19  -2.05103619682645E-01  -2.05103619682688E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34333853073502E-11   0.00000000000000E+00   4.34333853073502E-11
      3.88315372597401E-18  -2.05103603770713E-01  -2.03845783824052E-01   0.00000000000000E+00   9.59134879509755E-14
     -9.70980178655278E-23  -3.99249426209304E-09  -3.99239834860518E-09  -2.99364377117668E-18
      1.55831867338736E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00   1.37448150712941E-15   5.04492076856558E-23
      3.95041222884136E-09   3.95041360332292E-09  -8.89631334890673E-19  -2.04958771283765E-01  -2.04958771283808E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27164143806514E-11   0.00000000000000E+00   4.27164143806514E-11
      3.88528954669304E-18  -2.04958747410816E-01  -2.03700696895858E-01   0.00000000000000E+00   9.44660544512985E-14
     -9.70767365458681E-23  -3.99322448375793E-09  -3.99313001770358E-09  -2.99565821180237E-18
      1.60831867338736E-09
      0.00000000000000E+00  -3.95189535256546E-12   0.00000000000000E+00   1.34010180768056E-15   5.12535490470135E-23
      3.95183536150456E-09   3.95183670160642E-09  -8.89748948936645E-19  -2.04816421483589E-01  -2.04816421483631E-01
      0.00000000000000E+00   0.00000000000000E+00   4.20172942748324E-11   0.00000000000000E+00   4.20172942748324E-11
      3.88739041140678E-18  -2.04816395038499E-01  -2.03558116373507E-01   0.00000000000000E+00   9.30666097184567E-14
     -9.70557476059517E-23  -3.99394706249085E-09  -3.99385399588123E-09  -2.99764146247013E-18
      1.65831867338736E-09
      0.00000000000000E+00  -3.95327302362357E-12   0.00000000000000E+00   1.33069193338571E-15   5.20508526595023E-23
      3.95323338526019E-09   3.95323471595218E-09  -8.89863109218535E-19  -2.04676500461171E-01  -2.04676500461212E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13351844730190E-11   0.00000000000000E+00   4.13351844730190E-11
      3.88945717063043E-18  -2.04676482851809E-01  -2.03417978588719E-01   0.00000000000000E+00   9.16570361100607E-14
     -9.70350475624560E-23  -3.99466155746121E-09  -3.99456990042520E-09  -2.99959406141190E-18
      1.70831867338737E-09
      0.00000000000000E+00  -3.95465069468169E-12   0.00000000000000E+00   1.29082859627838E-15   5.28411700627021E-23
      3.95460687133702E-09   3.95460816216567E-09  -8.89974092461185E-19  -2.04538943444460E-01  -2.04538943444501E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06691506161452E-11   0.00000000000000E+00   4.06691506161452E-11
      3.89149062816124E-18  -2.04538951436670E-01  -2.03280224242146E-01   0.00000000000000E+00   9.03058879608689E-14
     -9.70146327698747E-23  -3.99536761866968E-09  -3.99527731278181E-09  -3.00151653570006E-18
      1.75831867338737E-09
      0.00000000000000E+00  -3.95593652100259E-12   0.00000000000000E+00   1.28543086063593E-15   5.36245590816061E-23
      3.95595671035828E-09   3.95595799578920E-09  -8.90082140420166E-19  -2.04403691847236E-01  -2.04403691847276E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00181832263439E-11   0.00000000000000E+00   4.00181832263439E-11
      3.89349153732256E-18  -2.04403743517082E-01  -2.03144796094760E-01   0.00000000000000E+00   8.89368099845824E-14
     -9.69944994673930E-23  -3.99606511582543E-09  -3.99597617901554E-09  -3.00340939690239E-18
      1.80831867338737E-09
      0.00000000000000E+00  -3.95731419206070E-12   0.00000000000000E+00   1.24519812305054E-15   5.44010830803205E-23
      3.95728429682731E-09   3.95728554202549E-09  -8.90187458958025E-19  -2.04270694915158E-01  -2.04270694915198E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93810719550937E-11   0.00000000000000E+00   3.93810719550937E-11
      3.89546059092031E-18  -2.04270801491793E-01  -2.03011636487478E-01   0.00000000000000E+00   8.76354684306400E-14
     -9.69746429480489E-23  -3.99675424944895E-09  -3.99666661398061E-09  -3.00527313196229E-18
      1.85831867338737E-09
      0.00000000000000E+00  -3.95860001838161E-12   0.00000000000000E+00   1.24290055308495E-15   5.51708185823790E-23
      3.95859154093184E-09   3.95859278383244E-09  -8.90290219531302E-19  -2.04139910169121E-01  -2.04139910169160E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87565370798378E-11   0.00000000000000E+00   3.87565370798378E-11
      3.89739841777430E-18  -2.04140064312654E-01  -2.02880684173011E-01   0.00000000000000E+00   8.63223998736928E-14
     -9.69550575481521E-23  -3.99743564331203E-09  -3.99734932091225E-09  -3.00710819824300E-18
      1.90831867338736E-09
      0.00000000000000E+00  -3.95988584470252E-12   0.00000000000000E+00   1.20694195710682E-15   5.59338483080293E-23
      3.95988067257057E-09   3.95988187951258E-09  -8.90390563670825E-19  -2.04011302289964E-01  -2.04011302290002E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81433307719974E-11   0.00000000000000E+00   3.81433307719974E-11
      3.89930558431290E-18  -2.04011465756834E-01  -2.02751872619334E-01   0.00000000000000E+00   8.50866527107365E-14
     -9.69357362103744E-23  -3.99811029693720E-09  -3.99802521028459E-09  -3.00891502064208E-18
      1.95831867338736E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00   1.20650777703244E-15   5.66902532922730E-23
      3.96115361828768E-09   3.96115482479551E-09  -8.90488614952637E-19  -2.03884838348995E-01  -2.03884838349033E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75406634213848E-11   0.00000000000000E+00   3.75406634213848E-11
      3.90118261748397E-18  -2.03884934965534E-01  -2.02625130609221E-01   0.00000000000000E+00   8.38503157838339E-14
     -9.69166713669925E-23  -3.99877933853254E-09  -3.99869548821686E-09  -3.01069400253134E-18
      2.00831867338737E-09
      0.00000000000000E+00  -3.96245749734433E-12   0.00000000000000E+00   1.17561609053590E-15   5.74400873193848E-23
      3.96241105522749E-09   3.96241223084364E-09  -8.90584497752020E-19  -2.03760479678255E-01  -2.03760479678292E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69485778835112E-11   0.00000000000000E+00   3.69485778835112E-11
      3.90303004637815E-18  -2.03760401746163E-01  -2.02500387723910E-01   0.00000000000000E+00   8.26854237466816E-14
     -9.68978560047240E-23  -3.99944349415084E-09  -3.99936080872719E-09  -3.01244554862613E-18
      2.05831867338737E-09
      0.00000000000000E+00  -3.96365147892802E-12   0.00000000000000E+00   1.17178891273511E-15   5.81833513091390E-23
      3.96365120386547E-09   3.96365237565444E-09  -8.90678362511777E-19  -2.03638170466045E-01  -2.03638170466081E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63684491491138E-11   0.00000000000000E+00   3.63684491491138E-11
      3.90484846883560E-18  -2.03637806987175E-01  -2.02377584979778E-01   0.00000000000000E+00   8.15080320556541E-14
     -9.68792862576316E-23  -4.00010233283551E-09  -4.00002082480355E-09  -3.01417010632383E-18
      2.10831867338737E-09
      0.00000000000000E+00  -3.96493730524893E-12   0.00000000000000E+00   1.13694965457751E-15   5.89199613173365E-23
      3.96486891075123E-09   3.96487004770094E-09  -8.90770409047879E-19  -2.03517827092893E-01  -2.03517827092928E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58030581850121E-11   0.00000000000000E+00   3.58030581850121E-11
      3.90663862174485E-18  -2.03517118081715E-01  -2.02256690518734E-01   0.00000000000000E+00   8.03563159468926E-14
     -9.68609638517409E-23  -4.00075346220177E-09  -4.00067310588592E-09  -3.01586821269698E-18
      2.15831867338737E-09
      0.00000000000000E+00  -3.96603944209542E-12   0.00000000000000E+00   1.12098919707331E-15   5.96497416113014E-23
      3.96605556832894E-09   3.96605668931819E-09  -8.90860897649104E-19  -2.03399333045646E-01  -2.03399333045681E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52562215534771E-11   0.00000000000000E+00   3.52562215534771E-11
      3.90840143282253E-18  -2.03398344627577E-01  -2.02137715448829E-01   0.00000000000000E+00   7.91315958702938E-14
     -9.68428985966635E-23  -4.00139204246744E-09  -4.00131291087167E-09  -3.01754053517342E-18
      2.20831867338737E-09
      0.00000000000000E+00  -3.96714157894191E-12   0.00000000000000E+00   1.06676162423999E-15   6.03724498427810E-23
      3.96720084504953E-09   3.96720191181122E-09  -8.90950129943243E-19  -2.03282548067570E-01  -2.03282548067605E-01
      0.00000000000000E+00   0.00000000000000E+00   3.47313915047476E-11   0.00000000000000E+00   3.47313915047476E-11
      3.91013800239776E-18  -2.03281547539497E-01  -2.02020722852951E-01   0.00000000000000E+00   7.78623243694142E-14
     -9.68251081644571E-23  -4.00201116564025E-09  -4.00193330331598E-09  -3.01918787245452E-18
      2.25831867338737E-09
      0.00000000000000E+00  -3.96824371578840E-12   0.00000000000000E+00   1.04108167008406E-15   6.10878644511559E-23
      3.96829668289627E-09   3.96829772397800E-09  -8.91038386658913E-19  -2.03167337777070E-01  -2.03167337777104E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42294364552497E-11   0.00000000000000E+00   3.42294364552497E-11
      3.91184947422053E-18  -2.03166829963179E-01  -2.01905818140997E-01   0.00000000000000E+00   7.64564376935967E-14
     -9.68076143554261E-23  -4.00260361687089E-09  -4.00252716043329E-09  -3.02081108756162E-18
      2.30831867338737E-09
      0.00000000000000E+00  -3.96934585263489E-12   0.00000000000000E+00   9.70679984537220E-16   6.17959383601629E-23
      3.96934368099221E-09   3.96934465167225E-09  -8.91125815449565E-19  -2.03053627288039E-01  -2.03053627288073E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37456706921343E-11   0.00000000000000E+00   3.37456706921343E-11
      3.91353675775513E-18  -2.03054299997848E-01  -2.01793110697295E-01   0.00000000000000E+00   7.50312544689022E-14
     -9.67904333699268E-23  -4.00316535361873E-09  -4.00309032236435E-09  -3.02241094230557E-18
      2.35831867338737E-09
      0.00000000000000E+00  -3.97035614474417E-12   0.00000000000000E+00   9.66169816646705E-16   6.24969873328533E-23
      3.97035842815164E-09   3.97035939432152E-09  -8.91212285978087E-19  -2.02941470913582E-01  -2.02941470913616E-01
      0.00000000000000E+00   0.00000000000000E+00   3.32673611200609E-11   0.00000000000000E+00   3.32673611200609E-11
      3.91520012581114E-18  -2.02943998900495E-01  -2.01682640558829E-01   0.00000000000000E+00   7.35724083801908E-14
     -9.67735612209225E-23  -4.00370032784984E-09  -4.00362675544156E-09  -3.02398783983305E-18
      2.40831867338737E-09
      0.00000000000000E+00  -3.97136643685346E-12   0.00000000000000E+00   9.41775719394882E-16   6.31918743365270E-23
      3.97137903065221E-09   3.97137997242799E-09  -8.91297257771140E-19  -2.02831116627335E-01  -2.02831116627368E-01
      0.00000000000000E+00   0.00000000000000E+00   3.27730715211672E-11   0.00000000000000E+00   3.27730715211672E-11
      3.91683877938719E-18  -2.02835802879207E-01  -2.01574278675310E-01   0.00000000000000E+00   7.23689673989967E-14
     -9.67569563273433E-23  -4.00422541291646E-09  -4.00415304394916E-09  -3.02554152161606E-18
      2.45831867338737E-09
      0.00000000000000E+00  -3.97237672896274E-12   0.00000000000000E+00   1.00840085456059E-15   6.38820433524735E-23
      3.97246424493061E-09   3.97246525333153E-09  -8.91379741137073E-19  -2.02723027082215E-01  -2.02723027082247E-01
      0.00000000000000E+00   0.00000000000000E+00   3.22360908930079E-11   0.00000000000000E+00   3.22360908930079E-11
      3.91845058393185E-18  -2.02729325179063E-01  -2.01467628188880E-01   0.00000000000000E+00   7.15438124382532E-14
     -9.67405270609632E-23  -4.00477288803688E-09  -4.00470134422454E-09  -3.02707084279477E-18
      2.50831867338737E-09
      0.00000000000000E+00  -3.97366255528364E-12   0.00000000000000E+00   1.13946771603146E-15   6.45693045124776E-23
      3.97368126340367E-09   3.97368240287145E-09  -8.91458452352321E-19  -2.02617808754102E-01  -2.02617808754133E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16334237107436E-11   0.00000000000000E+00   3.16334237107436E-11
      3.92003225511738E-18  -2.02623870163361E-01  -2.01361979535931E-01   0.00000000000000E+00   7.13569371862022E-14
     -9.67241337370078E-23  -4.00538718351932E-09  -4.00531582658224E-09  -3.02857380276506E-18
      2.55831867338737E-09
      0.00000000000000E+00  -3.97513207107897E-12   0.00000000000000E+00   1.33773260629429E-15   6.52552282167847E-23
      3.97507858423510E-09   3.97507992196777E-09  -8.91532250499425E-19  -2.02516006622479E-01  -2.02516006622510E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09607449394246E-11   0.00000000000000E+00   3.09607449394246E-11
      3.92158029236436E-18  -2.02518506746488E-01  -2.01256387719169E-01   0.00000000000000E+00   7.18641275389018E-14
     -9.67076176714211E-23  -4.00611253103461E-09  -4.00604066690716E-09  -3.03004804186493E-18
      2.60831867338737E-09
      0.00000000000000E+00  -3.97669343161149E-12   0.00000000000000E+00   1.50394086458413E-15   6.59401054119946E-23
      3.97664503558052E-09   3.97664653952145E-09  -8.91600876679444E-19  -2.02417752992104E-01  -2.02417752992134E-01
      0.00000000000000E+00   0.00000000000000E+00   3.02506255582809E-11   0.00000000000000E+00   3.02506255582809E-11
      3.92309282364227E-18  -2.02412327110189E-01  -2.01149938196955E-01   0.00000000000000E+00   7.29046446362158E-14
     -9.66908646284172E-23  -4.00697006972428E-09  -4.00689716507974E-09  -3.03149194696283E-18
      2.65831867338737E-09
      0.00000000000000E+00  -3.97825479214402E-12   0.00000000000000E+00   1.60734142545739E-15   6.66217293238078E-23
      3.97826404779352E-09   3.97826565513501E-09  -8.91665871988459E-19  -2.02322327486429E-01  -2.02322327486458E-01
      0.00000000000000E+00   0.00000000000000E+00   2.95875126965322E-11   0.00000000000000E+00   2.95875126965322E-11
      3.92457219927710E-18  -2.02304919029099E-01  -2.01042228896788E-01   0.00000000000000E+00   7.37714491675508E-14
     -9.66739007219376E-23  -4.00792693928064E-09  -4.00785316783157E-09  -3.03290632728864E-18
      2.70831867338737E-09
      0.00000000000000E+00  -3.97963246320213E-12   0.00000000000000E+00   1.35094458151748E-15   6.72942869327788E-23
      3.97968290176571E-09   3.97968425271036E-09  -8.91731362877082E-19  -2.02227774533857E-01  -2.02227774533886E-01
      0.00000000000000E+00   0.00000000000000E+00   2.91089305669852E-11   0.00000000000000E+00   2.91089305669852E-11
      3.92602764580544E-18  -2.02196987585031E-01  -2.00934001235752E-01   0.00000000000000E+00   7.35235193633732E-14
     -9.66569984396627E-23  -4.00886670679654E-09  -4.00879318327728E-09  -3.03429628292836E-18
      2.75831867338737E-09
      0.00000000000000E+00  -3.98055091057421E-12   0.00000000000000E+00   7.77433332759404E-16   6.79483079605439E-23
      3.98052493297524E-09   3.98052571040864E-09  -8.91804190251060E-19  -2.02130827897777E-01  -2.02130827897806E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89806750862626E-11   0.00000000000000E+00   2.89806750862626E-11
      3.92747667955976E-18  -2.02090947183995E-01  -2.00827736093963E-01   0.00000000000000E+00   7.05668170015629E-14
     -9.66407482412247E-23  -4.00957695231184E-09  -4.00950638549494E-09  -3.03567248930870E-18
      2.80831867338737E-09
      0.00000000000000E+00  -3.98036722109979E-12   0.00000000000000E+00   1.71959554653047E-16   6.85723261118205E-23
      3.98037702711520E-09   3.98037719907482E-09  -8.91892751923206E-19  -2.02027444288877E-01  -2.02027444288906E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93354392265286E-11   0.00000000000000E+00   2.93354392265286E-11
      3.92894345152108E-18  -2.01991136140719E-01  -2.00727860146872E-01   0.00000000000000E+00   6.32919322785298E-14
     -9.66260274750881E-23  -4.00977593023354E-09  -4.00971263830136E-09  -3.03705069959788E-18
      2.85831867338737E-09
      0.00000000000000E+00  -3.97898955004168E-12   0.00000000000000E+00  -1.32183727084047E-15   6.91571883376448E-23
      3.97897083357477E-09   3.97896951173757E-09  -8.92004053552293E-19  -2.01914193238252E-01  -2.01914193238282E-01
      0.00000000000000E+00   0.00000000000000E+00   3.01761859523536E-11   0.00000000000000E+00   3.01761859523536E-11
      3.93045226081870E-18  -2.01903228382426E-01  -2.00640130890260E-01   0.00000000000000E+00   5.23648088141583E-14
     -9.66137958019921E-23  -4.00919806249863E-09  -4.00914569768991E-09  -3.03844820726641E-18
      2.88331867338737E-09
      0.00000000000000E+00  -3.97788741319519E-12   0.00000000000000E+00   1.72896060520299E-14   6.94389883408713E-23
      3.97794709099208E-09   3.97796438059820E-09  -8.92066114560198E-19  -2.01854743960299E-01  -2.01854743960330E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07061180316098E-11   0.00000000000000E+00   3.07061180316098E-11
      3.93121991376949E-18  -2.01862944568819E-01  -2.00600002839332E-01   0.00000000000000E+00   2.64698475628362E-14
     -9.66079395801619E-23  -4.00869696847729E-09  -4.00867049862982E-09  -3.03915379920929E-18
      2.89175617338737E-09
      0.00000000000000E+00  -3.97752003424636E-12   0.00000000000000E+00  -2.17760385650375E-15   6.95335059139367E-23
      3.97759434457490E-09   3.97759216697111E-09  -8.92087498569547E-19  -2.01834491634017E-01  -2.01834491634048E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08434034864587E-11   0.00000000000000E+00   3.08434034864587E-11
      3.93148015498641E-18  -2.01849853211841E-01  -2.00586979368260E-01   0.00000000000000E+00   4.39717691100938E-14
     -9.66065964271070E-23  -4.00847954222657E-09  -4.00843557045755E-09  -3.03939265641686E-18
      2.90314679838737E-09
      0.00000000000000E+00  -3.97706081056032E-12   0.00000000000000E+00  -2.65246848515649E-15   6.96586177722122E-23
      3.97700958898926E-09   3.97700693652085E-09  -8.92117846767364E-19  -2.01806490384149E-01  -2.01806490384180E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11248851719894E-11   0.00000000000000E+00   3.11248851719894E-11
      3.93183468688157E-18  -2.01833038658938E-01  -2.00570260503941E-01   0.00000000000000E+00   4.04892304774033E-14
     -9.66044954164878E-23  -4.00817231092316E-09  -4.00813182169278E-09  -3.03971684011421E-18
      2.91852414213737E-09
      0.00000000000000E+00  -3.97605051845104E-12   0.00000000000000E+00  -3.07678991817975E-15   6.98230386840717E-23
      3.97609116622613E-09   3.97608808943628E-09  -8.92161539567614E-19  -2.01767470391441E-01  -2.01767470391472E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15369223055870E-11   0.00000000000000E+00   3.15369223055870E-11
      3.93231964097668E-18  -2.01812106007674E-01  -2.00549487512849E-01   0.00000000000000E+00   3.56427724193440E-14
     -9.66018957098218E-23  -4.00766065451432E-09  -4.00762501174199E-09  -3.04015810140907E-18
      2.93928355619987E-09
      0.00000000000000E+00  -3.97467284739293E-12   0.00000000000000E+00  -3.56317927699596E-15   7.00373966403691E-23
      3.97465119489971E-09   3.97464763172050E-09  -8.92225205791690E-19  -2.01712691141588E-01  -2.01712691141620E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21122789678265E-11   0.00000000000000E+00   3.21122789678265E-11
      3.93298627307226E-18  -2.01787511368461E-01  -2.00525165412627E-01   0.00000000000000E+00   2.87210520770165E-14
     -9.65990247204576E-23  -4.00678863174026E-09  -4.00675991068828E-09  -3.04076106728058E-18
      2.96730876518424E-09
      0.00000000000000E+00  -3.97256041843715E-12   0.00000000000000E+00  -3.92288380406348E-15   7.03159304632999E-23
      3.97249074172385E-09   3.97248681884012E-09  -8.92317780857683E-19  -2.01635774979417E-01  -2.01635774979450E-01
      0.00000000000000E+00   0.00000000000000E+00   3.28165029029251E-11   0.00000000000000E+00   3.28165029029251E-11
      3.93390596242426E-18  -2.01761666289255E-01  -2.00499779231525E-01   0.00000000000000E+00   1.94592124359169E-14
     -9.65963064693518E-23  -4.00532278095535E-09  -4.00530332174301E-09  -3.04158818156657E-18
      3.00514279731315E-09
      0.00000000000000E+00  -3.96989692105814E-12   0.00000000000000E+00  -3.56045841873231E-15   7.06882360360719E-23
      3.96987886651251E-09   3.96987530605416E-09  -8.92444122462190E-19  -2.01531541811339E-01  -2.01531541811372E-01
      0.00000000000000E+00   0.00000000000000E+00   3.32223945187969E-11   0.00000000000000E+00   3.32223945187969E-11
      3.93516289956588E-18  -2.01739462375038E-01  -2.00478270182649E-01   0.00000000000000E+00   1.05216726670557E-14
     -9.65941578754789E-23  -4.00310822224550E-09  -4.00309770057293E-09  -3.04271877710369E-18
      3.05514279731315E-09
      0.00000000000000E+00  -3.96971323158372E-12   0.00000000000000E+00  -2.44447781656471E-16   7.12420386242802E-23
      3.96966976518474E-09   3.96966952073703E-09  -8.92566296819953E-19  -2.01415450000971E-01  -2.01415450001003E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15110568554956E-11   0.00000000000000E+00   3.15110568554956E-11
      3.93673845240865E-18  -2.01718398426332E-01  -2.00457810252124E-01   0.00000000000000E+00   1.54913436575405E-14
     -9.65901965445931E-23  -4.00119606893610E-09  -4.00118057759254E-09  -3.04417215558870E-18
      3.10514279731315E-09
      0.00000000000000E+00  -3.97605051845104E-12   0.00000000000000E+00   6.73132570048596E-15   7.19501966909015E-23
      3.97607194502329E-09   3.97607867634907E-09  -8.92578625521117E-19  -2.01352111468013E-01  -2.01352111468039E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62909680889882E-11   0.00000000000000E+00   2.62909680889882E-11
      3.93805300081310E-18  -2.01676274378698E-01  -2.00415311703795E-01   0.00000000000000E+00   4.85285172164308E-14
     -9.65787726806353E-23  -4.00241817295515E-09  -4.00236964443803E-09  -3.04547437529199E-18
      3.15514279731315E-09
      0.00000000000000E+00  -3.99193965798794E-12   0.00000000000000E+00   1.68812462346365E-14   7.29028939775631E-23
      3.99195934371197E-09   3.99197622495828E-09  -8.92416292006573E-19  -2.01372865898840E-01  -2.01372865898857E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70206166617862E-11   0.00000000000000E+00   1.70206166617862E-11
      3.93890403164619E-18  -2.01569990911945E-01  -2.00306940517499E-01   0.00000000000000E+00   1.16293139332293E-13
     -9.65520346636823E-23  -4.00911313475930E-09  -4.00899684162007E-09  -3.04648773963962E-18
      3.20514279731315E-09
      0.00000000000000E+00  -4.01783987388047E-12   0.00000000000000E+00   2.73070590057897E-14   7.41396062315702E-23
      4.01782210642105E-09   4.01784941348013E-09  -8.92048309791963E-19  -2.01493354680734E-01  -2.01493354680739E-01
      0.00000000000000E+00   0.00000000000000E+00   4.76780675580296E-12   0.00000000000000E+00   4.76780675580296E-12
      3.93914242198398E-18  -2.01352729840691E-01  -2.00085388396277E-01   0.00000000000000E+00   2.13696002670305E-13
     -9.65033324829286E-23  -4.02283091623850E-09  -4.02261722023593E-09  -3.04709411219202E-18
      3.25514279731315E-09
      0.00000000000000E+00  -4.04943446347985E-12   0.00000000000000E+00   4.25051220341792E-14   7.55839144751311E-23
      4.04945508765819E-09   4.04949759278030E-09  -8.91522015671735E-19  -2.01692240652478E-01  -2.01692240652471E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96944680145774E-12   0.00000000000000E+00  -6.96944680145774E-12
      3.93879394964391E-18  -2.00994689156981E-01  -1.99721077565599E-01   0.00000000000000E+00   3.06126221253821E-13
     -9.64316017299048E-23  -4.04283427220002E-09  -4.04252814597886E-09  -3.04727193397217E-18
      3.30514279731315E-09
      0.00000000000000E+00  -4.07606943727004E-12   0.00000000000000E+00   2.70019564548804E-14   7.69794619226930E-23
      4.07602984893859E-09   4.07605685089512E-09  -8.91005265165283E-19  -2.01890803958426E-01  -2.01890803958414E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19570322310352E-11   0.00000000000000E+00  -1.19570322310352E-11
      3.93819609803236E-18  -2.00513299930132E-01  -1.99232888626678E-01   0.00000000000000E+00   3.73895828117168E-13
     -9.63468063286810E-23  -4.06447371449210E-09  -4.06409981866408E-09  -3.04719083286708E-18
      3.35514279731315E-09
      0.00000000000000E+00  -4.07974322675834E-12   0.00000000000000E+00   6.88020436950900E-15   7.78641904828865E-23
      4.07982533602627E-09   4.07983221623072E-09  -8.90803579309844E-19  -2.01944108532131E-01  -2.01944108532129E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.98897558195239E-12   0.00000000000000E+00  -1.98897558195239E-12
      3.93809664925326E-18  -2.00006659791340E-01  -1.98721919152644E-01   0.00000000000000E+00   3.15998216623461E-13
     -9.62742282897861E-23  -4.07815923886532E-09  -4.07784324064879E-09  -3.04729306994342E-18
      3.40514279731315E-09
      0.00000000000000E+00  -4.03942338712423E-12   0.00000000000000E+00  -1.19996240182227E-14   7.76320472648993E-23
      4.03943190968326E-09   4.03941991005931E-09  -8.91327081346115E-19  -2.01655771786065E-01  -2.01655771786096E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07249532140502E-11   0.00000000000000E+00   3.07249532140502E-11
      3.93963289691396E-18  -1.99672528711260E-01  -1.98390221157119E-01   0.00000000000000E+00   5.36256150648152E-14
     -9.62551770878987E-23  -4.07019848888829E-09  -4.07014486327332E-09  -3.04830581556785E-18
      3.45514279731315E-09
      0.00000000000000E+00  -3.93793495250992E-12   0.00000000000000E+00  -1.01732566208389E-13   7.57340258948008E-23
      3.93800755344190E-09   3.93790582087576E-09  -8.92978280459000E-19  -2.00830313981011E-01  -2.00830313981100E-01
      0.00000000000000E+00   0.00000000000000E+00   8.91049233441327E-11   0.00000000000000E+00   8.91049233441327E-11
      3.94408814308117E-18  -1.99788798138000E-01  -1.98520070914130E-01   0.00000000000000E+00  -3.75486377205702E-13
     -9.63395900571674E-23  -4.02663525784264E-09  -4.02701074421995E-09  -3.05110986262217E-18
      3.50514279731315E-09
      0.00000000000000E+00  -3.77628821502467E-12   0.00000000000000E+00  -4.63835748357122E-14   7.20312506387762E-23
      3.77644196812721E-09   3.77639558455244E-09  -8.95939270990330E-19  -1.99374117621502E-01  -1.99374117621667E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64951594870794E-10   0.00000000000000E+00   1.64951594870794E-10
      3.95233572282471E-18  -2.00630462616983E-01  -1.99388760439354E-01   0.00000000000000E+00  -1.13180555034638E-12
     -9.65670878851147E-23  -3.94021537387276E-09  -3.94134717942320E-09  -3.05639645183438E-18
      3.55514279731315E-09
      0.00000000000000E+00  -3.58791465901203E-12   0.00000000000000E+00  -1.89830452461463E-13   6.72001455494533E-23
      3.58808771638366E-09   3.58789788593127E-09  -8.99868597282194E-19  -1.97441697848758E-01  -1.97441697848991E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33044166669093E-10   0.00000000000000E+00   2.33044166669093E-10
      3.96398793115816E-18  -2.02319178917462E-01  -2.01115374524202E-01   0.00000000000000E+00  -1.66167823828437E-12
     -9.69359989435064E-23  -3.81928037436199E-09  -3.82094205260037E-09  -3.06411933387597E-18
      3.60514279731315E-09
      0.00000000000000E+00  -3.44629007423803E-12   0.00000000000000E+00  -1.43516318249888E-13   6.30198187776282E-23
      3.44646285084392E-09   3.44631933452574E-09  -9.03575839967273E-19  -1.95595097158369E-01  -1.95595097158619E-01
      0.00000000000000E+00   0.00000000000000E+00   2.50046132631651E-10   0.00000000000000E+00   2.50046132631651E-10
      3.97649023778975E-18  -2.04657611457528E-01  -2.03493056127207E-01   0.00000000000000E+00  -1.97011063453470E-12
     -9.73668695753724E-23  -3.69439535652276E-09  -3.69636546715739E-09  -3.07291439782247E-18
      3.65514279731315E-09
      0.00000000000000E+00  -3.45813804533780E-12   0.00000000000000E+00   1.02210574909535E-14   6.23138353263287E-23
      3.45816213816976E-09   3.45817235922731E-09  -9.04929537760386E-19  -1.94852960759616E-01  -1.94852960759781E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64958681635840E-10   0.00000000000000E+00   1.64958681635840E-10
      3.98473817187154E-18  -2.07004696523885E-01  -2.05863215364309E-01   0.00000000000000E+00  -1.47280964208693E-12
     -9.76849435049505E-23  -3.62165823122097E-09  -3.62313104086316E-09  -3.07980863411115E-18
      3.70514279731315E-09
      0.00000000000000E+00  -3.73743789118589E-12   0.00000000000000E+00   2.79106881612643E-13   6.85205436366641E-23
      3.73719148295746E-09   3.73747058983914E-09  -9.01378760747350E-19  -1.96440413130975E-01  -1.96440413130919E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60379153901621E-11   0.00000000000000E+00  -5.60379153901621E-11
      3.98193627610203E-18  -2.08230521544915E-01  -2.07070674161890E-01   0.00000000000000E+00   2.04023718105553E-13
     -9.76416362314583E-23  -3.68163669816697E-09  -3.68143267444897E-09  -3.08055751535468E-18
      3.75514279731315E-09
      0.00000000000000E+00  -4.36455375683888E-12   0.00000000000000E+00   6.28757800136125E-13   8.48098121217783E-23
      4.36397436881844E-09   4.36460312661866E-09  -8.91298390571796E-19  -2.01140152934071E-01  -2.01140152933672E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99117087455393E-10   0.00000000000000E+00  -3.99117087455393E-10
      3.96198042172926E-18  -2.06736790947862E-01  -2.05487453131623E-01   0.00000000000000E+00   2.99667161994312E-12
     -9.69880383045978E-23  -3.96848271078313E-09  -3.96548603916329E-09  -3.07068203115747E-18
      3.80514279731315E-09
      0.00000000000000E+00  -5.32984194488999E-12   0.00000000000000E+00   9.67634500993620E-13   1.12311288815919E-22
      5.32883469509368E-09   5.32980232959478E-09  -8.75457360901231E-19  -2.08604147745927E-01  -2.08604147745133E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.93544917196910E-10   0.00000000000000E+00  -7.93544917196910E-10
      3.92230317586942E-18  -2.00651776307075E-01  -1.99222614344232E-01   0.00000000000000E+00   6.23662866342232E-12
     -9.55682473433612E-23  -4.54249404106123E-09  -4.53625741239790E-09  -3.04684581496819E-18
      3.85514279731315E-09
      0.00000000000000E+00  -6.47229863101441E-12   0.00000000000000E+00   1.15478095739792E-12   1.47480038775245E-22
      6.47113570549255E-09   6.47229048645010E-09  -8.57118400644434E-19  -2.17345132210470E-01  -2.17345132209327E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14300278868104E-09   0.00000000000000E+00  -1.14300278868104E-09
      3.86515303643536E-18  -1.88464274937726E-01  -1.86785264112778E-01   0.00000000000000E+00   8.93960783712352E-12
     -9.33866401821024E-23  -5.33822730560605E-09  -5.32928769776902E-09  -3.00803463579093E-18
      3.90514279731315E-09
      0.00000000000000E+00  -7.44603653488861E-12   0.00000000000000E+00   9.75312891502966E-13   1.80300927966649E-22
      7.44507930480819E-09   7.44605461769987E-09  -8.40761971595069E-19  -2.25342380354583E-01  -2.25342380353238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34433310690151E-09   0.00000000000000E+00  -1.34433310690151E-09
      3.79793638109029E-18  -1.70283656003878E-01  -1.68361273481783E-01   0.00000000000000E+00   1.02102148167017E-11
     -9.07247595624199E-23  -6.11193172561497E-09  -6.10172151079836E-09  -2.95717440949522E-18
      3.95514279731315E-09
      0.00000000000000E+00  -7.71064122278349E-12   0.00000000000000E+00   2.69146522097554E-13   1.94417073981773E-22
      7.71038392315961E-09   7.71065306968190E-09  -8.31748903040529E-19  -2.30112952077761E-01  -2.30112952076548E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21297445076433E-09   0.00000000000000E+00  -1.21297445076433E-09
      3.73728765855207E-18  -1.49693060666273E-01  -1.47645918280008E-01   0.00000000000000E+00   9.05141669080418E-12
     -8.83383128128650E-23  -6.50673003560831E-09  -6.49767861891760E-09  -2.90553875551154E-18
      4.00514279731315E-09
      0.00000000000000E+00  -6.71550349513994E-12   0.00000000000000E+00  -9.84025970681088E-13   1.73045842993470E-22
      6.71649019370194E-09   6.71550616773143E-09  -8.36752159589734E-19  -2.28393200720250E-01  -2.28393200719761E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.89201380998994E-10   0.00000000000000E+00  -4.89201380998994E-10
      3.71282758950212E-18  -1.34261366727743E-01  -1.32299714196769E-01   0.00000000000000E+00   4.86689548872876E-12
     -8.71083331743097E-23  -6.23117168222104E-09  -6.22630478673239E-09  -2.87607542991239E-18
      4.05514279731315E-09
      0.00000000000000E+00  -4.52610864958692E-12   0.00000000000000E+00  -2.17970201011824E-12   1.16499648936396E-22
      4.52826183925958E-09   4.52608213724958E-09  -8.61229544167848E-19  -2.17308036075472E-01  -2.17308036076269E-01
      0.00000000000000E+00   0.00000000000000E+00   7.97027431066219E-10   0.00000000000000E+00   7.97027431066219E-10
      3.75267896105543E-18  -1.31244689862813E-01  -1.29567591740764E-01   0.00000000000000E+00  -1.95681142985213E-12
     -8.78294267674202E-23  -5.32115275688585E-09  -5.32310956831579E-09  -2.89144941688758E-18
      4.10514279731314E-09
      0.00000000000000E+00  -2.00056206585435E-12   0.00000000000000E+00  -2.53651547122727E-12   4.76017745712711E-23
      2.00309532214648E-09   2.00055880667530E-09  -9.06336045034646E-19  -1.95916831459521E-01  -1.95916831461687E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16537255486758E-09   0.00000000000000E+00   2.16537255486758E-09
      3.86094758879881E-18  -1.42064317094037E-01  -1.40751794723593E-01   0.00000000000000E+00  -1.09128096219637E-11
     -9.06500344650768E-23  -4.15501855192085E-09  -4.16593136154291E-09  -2.95461154376417E-18
      4.15514279731314E-09
      0.00000000000000E+00   1.54299158508645E-14   0.00000000000000E+00  -2.06548307467248E-12  -9.28949091041057E-24
     -1.34119356699960E-11  -1.54774187446777E-11  -9.70606275138582E-19  -1.64429024073644E-01  -1.64429024076837E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19219370125127E-09   0.00000000000000E+00   3.19219370125127E-09
      4.02055727386138E-18  -1.61943127043478E-01  -1.60942261644253E-01   0.00000000000000E+00  -2.19591251272923E-11
     -9.58773375982615E-23  -3.15475715737922E-09  -3.17671628250660E-09  -3.04995099872279E-18
      4.20514279731314E-09
      0.00000000000000E+00   1.15972349671944E-12   0.00000000000000E+00  -1.24473411758254E-12  -3.72360654654967E-23
     -1.15851167737265E-09  -1.15975641149027E-09  -1.04910782104414E-18  -1.24524848591316E-01  -1.24524848595027E-01
      0.00000000000000E+00   0.00000000000000E+00   3.71126896241838E-09   0.00000000000000E+00   3.71126896241838E-09
      4.20612072198230E-18  -1.83828231005120E-01  -1.83024337178632E-01   0.00000000000000E+00  -3.39417612173595E-11
     -1.02712869273103E-22  -2.51757078971062E-09  -2.55151255092809E-09  -3.15701290093815E-18
      4.25514279731314E-09
      0.00000000000000E+00   1.51396864812887E-12   0.00000000000000E+00  -5.01147682342777E-13  -4.48195306153764E-23
     -1.51348230619700E-09  -1.51398345387938E-09  -1.12975648920746E-18  -8.16665288703723E-02  -8.16665288740255E-02
      0.00000000000000E+00   0.00000000000000E+00   3.65321990563516E-09   0.00000000000000E+00   3.65321990563516E-09
      4.38878171726405E-18  -2.03255630405614E-01  -2.02581625609366E-01   0.00000000000000E+00  -4.34283765459561E-11
     -1.09905216974452E-22  -2.09580807520972E-09  -2.13923645175579E-09  -3.25902522805659E-18
      4.30514279731314E-09
      0.00000000000000E+00   1.28747952617511E-12   0.00000000000000E+00   7.33408126696355E-14  -4.64727000588899E-23
     -1.28749490408623E-09  -1.28742156327361E-09  -1.19474839898547E-18  -4.56353587198120E-02  -4.56353587227857E-02
      0.00000000000000E+00   0.00000000000000E+00   2.97368045217254E-09   0.00000000000000E+00   2.97368045217254E-09
      4.53746573987268E-18  -2.19948974353746E-01  -2.19417686090272E-01   0.00000000000000E+00  -4.50679426262619E-11
     -1.16400731669227E-22  -1.64119094627253E-09  -1.68625888889890E-09  -3.34271734088721E-18
      4.35514279731314E-09
      0.00000000000000E+00   7.40176737155458E-13   0.00000000000000E+00   4.45352354246956E-13  -4.69992654686837E-23
     -7.40636377707621E-10  -7.40191025353421E-10  -1.23132231067009E-18  -2.48880124826849E-02  -2.48880124845498E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86494104327214E-09   0.00000000000000E+00   1.86494104327214E-09
      4.63071279203629E-18  -2.34699232769894E-01  -2.34344858249282E-01   0.00000000000000E+00  -3.49892454803268E-11
     -1.21002522918225E-22  -1.08976077243830E-09  -1.12475001791875E-09  -3.39939048136619E-18
      4.40514279731314E-09
      0.00000000000000E+00   3.39825527667849E-13   0.00000000000000E+00   3.54778889800110E-13  -4.71877625666201E-23
     -3.40221119599915E-10  -3.39866340710162E-10  -1.24761542390746E-18  -1.57506050108228E-02  -1.57506050118541E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03133037187977E-09   0.00000000000000E+00   1.03133037187977E-09
      4.68227931063028E-18  -2.46630126834442E-01  -2.46412268456041E-01   0.00000000000000E+00  -2.23053589441908E-11
     -1.23771213859216E-22  -6.69158672225295E-10  -6.91464031169610E-10  -3.43466388672282E-18
      4.45514279731314E-09
      0.00000000000000E+00   1.59626153266681E-13   0.00000000000000E+00   1.64143608525551E-13  -4.72511677543015E-23
     -1.59834907942829E-10  -1.59670764334351E-10  -1.25483958397030E-18  -1.19307098858493E-02  -1.19307098864687E-02
      0.00000000000000E+00   0.00000000000000E+00   6.19327127916898E-10   0.00000000000000E+00   6.19327127916898E-10
      4.71324566702612E-18  -2.55974804755354E-01  -2.55829982799139E-01   0.00000000000000E+00  -1.42089959553224E-11
     -1.25468326448013E-22  -4.45447367627092E-10  -4.59656363582540E-10  -3.45840608305582E-18
      4.50514279731314E-09
      0.00000000000000E+00   7.37513239776440E-14   0.00000000000000E+00   8.33791145682616E-14  -4.72558678257095E-23
     -7.38652658776576E-11  -7.37818867631366E-11  -1.25778898594016E-18  -1.05992036328969E-02  -1.05992036333384E-02
      0.00000000000000E+00   0.00000000000000E+00   4.41470598745805E-10   0.00000000000000E+00   4.41470598745805E-10
      4.73531919696341E-18  -2.64645036857953E-01  -2.64529191484200E-01   0.00000000000000E+00  -1.09081173175114E-11
     -1.26731998110206E-22  -3.56780594665013E-10  -3.67688711982651E-10  -3.47753021102325E-18
      4.55514279731314E-09
      0.00000000000000E+00  -7.71495792543225E-15   0.00000000000000E+00   9.05503072782424E-14  -4.72001392724187E-23
      7.60413881570870E-12   7.69468912293974E-12  -1.25676553368598E-18  -1.14885991121204E-02  -1.14885991124891E-02
      0.00000000000000E+00   0.00000000000000E+00   3.68624088066459E-10   0.00000000000000E+00   3.68624088066459E-10
      4.75375040136673E-18  -2.75814039078535E-01  -2.75695474599631E-01   0.00000000000000E+00  -1.18221718709291E-11
     -1.28067154134003E-22  -3.64496605318351E-10  -3.76318777189408E-10  -3.49698486768076E-18
      4.60514279731314E-09
      0.00000000000000E+00  -1.82219958619733E-13   0.00000000000000E+00   2.06610034503354E-13  -4.70055217321381E-23
      1.82076540187206E-10   1.82283150221662E-10  -1.24732119561194E-18  -1.71500479605102E-02  -1.71500479606654E-02
      0.00000000000000E+00   0.00000000000000E+00   1.55214693897013E-10   0.00000000000000E+00   1.55214693897013E-10
      4.76151113606158E-18  -2.90055064862573E-01  -2.89948732294046E-01   0.00000000000000E+00  -1.00714467579349E-11
     -1.29186652886435E-22  -3.27426397360630E-10  -3.37497844118694E-10  -3.51418994044965E-18
      4.65514279731314E-09
      0.00000000000000E+00  -6.39698594650424E-13   0.00000000000000E+00   5.42348438051409E-13  -4.64100767302646E-23
      6.39183064445053E-10   6.39725412883058E-10  -1.21618771943421E-18  -3.50321997916545E-02  -3.50321997911086E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.45950405529914E-10   0.00000000000000E+00  -5.45950405529914E-10
      4.73421361578509E-18  -3.06540180839882E-01  -3.06510641030077E-01   0.00000000000000E+00   3.07360182239307E-12
     -1.28848732366326E-22  -9.68486091754257E-11  -9.37750073531615E-11  -3.51802589635088E-18
      4.70514279731314E-09
      0.00000000000000E+00  -1.17533710204472E-12   0.00000000000000E+00   6.62012513998248E-13  -4.48254895819351E-23
      1.17467933223975E-09   1.17534134475370E-09  -1.16233688014322E-18  -6.48397672450418E-02  -6.48397672437300E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.31179449762188E-09   0.00000000000000E+00  -1.31179449762188E-09
      4.66862389090399E-18  -3.23577713950911E-01  -3.23620717716278E-01   0.00000000000000E+00   1.75262208309611E-11
     -1.26846214946462E-22   1.18926932037396E-10   1.36453152868230E-10  -3.50628701076077E-18
      4.75514279731314E-09
      0.00000000000000E+00  -1.61417125642228E-12   0.00000000000000E+00   5.62902768006724E-13  -3.88427601746490E-23
      1.61357300840250E-09   1.61413591117047E-09  -1.09861620353358E-18  -9.85442582419930E-02  -9.85442582403092E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.68380518426090E-09   0.00000000000000E+00  -1.68380518426090E-09
      4.58443363169095E-18  -3.38687401795383E-01  -3.38709373791742E-01   0.00000000000000E+00   2.33273822592992E-11
     -1.24028732656893E-22   4.63418908312516E-11   6.96692730904268E-11  -3.48581742815737E-18
      4.80514279731314E-09
      0.00000000000000E+00  -2.36178741729155E-12   0.00000000000000E+00   8.49480095173165E-13  -1.61077661481084E-23
      2.36098610831141E-09   2.36183558840657E-09  -1.03077317224624E-18  -1.32758145559248E-01  -1.32758145557314E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93384767566786E-09   0.00000000000000E+00  -1.93384767566786E-09
      4.48774124790755E-18  -3.49401757701750E-01  -3.49266956179028E-01   0.00000000000000E+00   2.67345558597179E-11
     -1.20589997530251E-22  -4.54722468598293E-10  -4.27987912738696E-10  -3.45696807566132E-18
      4.85514279731314E-09
      0.00000000000000E+00  -4.00691035015277E-12   0.00000000000000E+00   1.71289009247245E-12   4.67467559947970E-23
      4.00517383456558E-09   4.00688672465810E-09  -9.61984519683344E-19  -1.65908587123338E-01  -1.65908587121087E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25043340308659E-09   0.00000000000000E+00  -2.25043340308659E-09
      4.37521957775322E-18  -3.50888963138374E-01  -3.50335650518539E-01   0.00000000000000E+00   3.17973791661130E-11
     -1.16213961191171E-22  -1.78825070073749E-09  -1.75645332157149E-09  -3.41323505806988E-18
      4.90514279731314E-09
      0.00000000000000E+00  -6.85492380622097E-12   0.00000000000000E+00   2.87434733484339E-12   1.55802022324551E-22
      6.85207508126024E-09   6.85494942859524E-09  -8.99835947871023E-19  -1.94860234517491E-01  -1.94860234514882E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60858392486574E-09   0.00000000000000E+00  -2.60858392486574E-09
      4.24479038150994E-18  -3.35519648151605E-01  -3.34181905954345E-01   0.00000000000000E+00   3.77734841638049E-11
     -1.10647624014369E-22  -4.28413898789322E-09  -4.24636550372953E-09  -3.34495443363891E-18
      4.93014279731314E-09
      0.00000000000000E+00  -8.64488588965846E-12   0.00000000000000E+00   3.58023889962804E-12   2.25455177893196E-22
      8.64131865918129E-09   8.64489889808115E-09  -8.72616851332601E-19  -2.07366340927541E-01  -2.07366340924732E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80905084912102E-09   0.00000000000000E+00  -2.80905084912102E-09
      4.17456411028191E-18  -3.21720541650598E-01  -3.19882031142859E-01   0.00000000000000E+00   3.86406978697871E-11
     -1.07638501815959E-22  -5.87448874682984E-09  -5.83584804896016E-09  -3.30194725894931E-18
      4.96389279731314E-09
      0.00000000000000E+00  -1.07053307241721E-11   0.00000000000000E+00   3.04708173873995E-12   3.08666158730385E-22
      1.07022988591066E-08   1.07053459408456E-08  -8.44313604887517E-19  -2.20516408290054E-01  -2.20516408287094E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95994679723687E-09   0.00000000000000E+00  -2.95994679723687E-09
      4.07466590587517E-18  -2.93132552055393E-01  -2.90692416949419E-01   0.00000000000000E+00   3.99679354059055E-11
     -1.03186727801534E-22  -7.78536707901456E-09  -7.74539914360876E-09  -3.23035230098765E-18
      5.00945529731314E-09
      0.00000000000000E+00  -1.24439515995106E-11   0.00000000000000E+00   1.90488663423100E-12   3.80369376722238E-22
      1.24419683255976E-08   1.24438732122322E-08  -8.18167368841620E-19  -2.33199417581661E-01  -2.33199417578598E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06367782925502E-09   0.00000000000000E+00  -3.06367782925502E-09
      3.93507708477974E-18  -2.43889502348325E-01  -2.40934274638867E-01   0.00000000000000E+00   3.59133542967157E-11
     -9.67854788974884E-23  -9.41610873727387E-09  -9.38019538297725E-09  -3.11690971593812E-18
      5.03445529731314E-09
      0.00000000000000E+00  -1.29851926358745E-11   0.00000000000000E+00   1.08500660534058E-12   4.04346843468232E-22
      1.29841093072171E-08   1.29851943138228E-08  -8.07093930490412E-19  -2.38824706043563E-01  -2.38824706040450E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.11280990027573E-09   0.00000000000000E+00  -3.11280990027573E-09
      3.85725683727284E-18  -2.15011488023918E-01  -2.11901165693107E-01   0.00000000000000E+00   3.01870971013385E-11
     -9.32724051650544E-23  -9.90257151064832E-09  -9.87238441354708E-09  -3.05016290678243E-18
      5.06820529731314E-09
      0.00000000000000E+00  -1.33444892478304E-11   0.00000000000000E+00   5.37336349238556E-13   4.19227624097625E-22
      1.33439145598038E-08   1.33444518961535E-08  -7.95163353381644E-19  -2.45239606374811E-01  -2.45239606371693E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.11846583635006E-09   0.00000000000000E+00  -3.11846583635006E-09
      3.75200861529603E-18  -1.75660836704527E-01  -1.72439077680229E-01   0.00000000000000E+00   2.51924200632198E-11
     -8.88626993799640E-23  -1.02511784798665E-08  -1.02259860598034E-08  -2.95684526191438E-18
      5.11376779731314E-09
      0.00000000000000E+00  -1.33416420609770E-11   0.00000000000000E+00   6.08198224867855E-15   4.18432748744898E-22
      1.33416210317937E-08   1.33416271137764E-08  -7.82389388677432E-19  -2.52648246580641E-01  -2.52648246577541E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.10077844610950E-09   0.00000000000000E+00  -3.10077844610950E-09
      3.61072939734517E-18  -1.24860053495866E-01  -1.21633578077389E-01   0.00000000000000E+00   1.93763925130998E-11
     -8.15084364001674E-23  -1.02602250601799E-08  -1.02408486676669E-08  -2.82834000866773E-18
      5.16376779731314E-09
      0.00000000000000E+00  -1.28947255697251E-11   0.00000000000000E+00  -4.33208238307777E-13   3.98172935133020E-22
      1.28951148913881E-08   1.28946816831502E-08  -7.70166396957439E-19  -2.60156516805257E-01  -2.60156516802198E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05809767997218E-09   0.00000000000000E+00  -3.05809767997218E-09
      3.45782451334656E-18  -7.67479695227473E-02  -7.36488360053325E-02   0.00000000000000E+00   1.32498527579351E-11
     -3.65791935223575E-23  -9.84983385593588E-09  -9.83658400317799E-09  -2.68765811638912E-18
      5.21376779731314E-09
      0.00000000000000E+00  -1.19217224237486E-11   0.00000000000000E+00  -9.49189408311742E-13   3.78213103961293E-22
      1.19226296217088E-08   1.19216804323009E-08  -7.53921091206479E-19  -2.69220605664385E-01  -2.69220605661447E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93810173069804E-09   0.00000000000000E+00  -2.93810173069804E-09
      3.31091942681165E-18  -4.30794303159594E-02  -4.02490313219820E-02   0.00000000000000E+00   8.19709912348502E-12
      1.10294478528987E-22  -8.99177580072648E-09  -8.98357870160288E-09  -2.55699833560518E-18
      5.26376779731314E-09
      0.00000000000000E+00  -1.06936664425468E-11   0.00000000000000E+00  -1.19541904428712E-12   3.79195107563970E-22
      1.06948142110706E-08   1.06936187920267E-08  -7.29166586564755E-19  -2.81444688166850E-01  -2.81444688164104E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74639269848607E-09   0.00000000000000E+00  -2.74639269848607E-09
      3.17359979188735E-18  -2.53919179877365E-02  -2.28880282328809E-02   0.00000000000000E+00   4.91845723020931E-12
      2.81297895995521E-22  -7.95214455077114E-09  -7.94722609354065E-09  -2.44443320532260E-18
      5.31376779731314E-09
      0.00000000000000E+00  -9.81021191534756E-12   0.00000000000000E+00  -8.53679648582189E-13   3.86212377276419E-22
      9.81107531880535E-09   9.81022163915716E-09  -6.99738984605154E-19  -2.95382299964877E-01  -2.95382299962275E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60190578363415E-09   0.00000000000000E+00  -2.60190578363415E-09
      3.04350450270564E-18  -1.70455967670309E-02  -1.47745072261805E-02   0.00000000000000E+00   3.08832960944207E-12
      4.09420134662234E-22  -7.21140418513286E-09  -7.20831585552301E-09  -2.34376551810049E-18
      5.36376779731314E-09
      0.00000000000000E+00  -9.37036746886071E-12   0.00000000000000E+00  -4.16182696492775E-13   3.86646229484085E-22
      9.37072577004931E-09   9.37030958735320E-09  -6.68377048333715E-19  -3.10129269250463E-01  -3.10129269247875E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58794946332478E-09   0.00000000000000E+00  -2.58794946332478E-09
      2.91410702953940E-18  -1.27219203750774E-02  -1.05850319573136E-02   0.00000000000000E+00   2.24935419286342E-12
      4.86375333758687E-22  -6.78460947822178E-09  -6.78236012402843E-09  -2.24572998120569E-18
      5.41376779731314E-09
      0.00000000000000E+00  -9.32067946603144E-12   0.00000000000000E+00  -3.04868147867438E-14   3.79527950079703E-22
      9.32070845962257E-09   9.32067797280816E-09  -6.34196268751889E-19  -3.26183572526001E-01  -3.26183572523244E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75625131591972E-09   0.00000000000000E+00  -2.75625131591972E-09
      2.77629446374342E-18  -1.01242455302258E-02  -8.05601839237609E-03   0.00000000000000E+00   1.96386607698562E-12
      5.26485911173973E-22  -6.56639052296597E-09  -6.56442665688845E-09  -2.14209819499153E-18
      5.46376779731314E-09
      0.00000000000000E+00  -9.23976425255161E-12   0.00000000000000E+00  -6.26313964571334E-14   3.54490373335854E-22
      9.23984298568908E-09   9.23978035429298E-09  -6.00553106225369E-19  -3.42112062581262E-01  -3.42112062578473E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78904090757987E-09   0.00000000000000E+00  -2.78904090757987E-09
      2.63684241836443E-18  -8.41888127915355E-03  -6.38647099870737E-03   0.00000000000000E+00   1.71091121564316E-12
      5.22056346511218E-22  -6.45245035792925E-09  -6.45073944671309E-09  -2.03628931213906E-18
      5.51376779731314E-09
      0.00000000000000E+00  -8.95917858038261E-12   0.00000000000000E+00  -2.62448795138964E-13   3.10038823750851E-22
      8.95943427741118E-09   8.95917182861635E-09  -5.71201385851611E-19  -3.56237922075359E-01  -3.56237922072788E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57149320217189E-09   0.00000000000000E+00  -2.57149320217189E-09
      2.50826775825583E-18  -7.28144408460183E-03  -5.26890029819052E-03   0.00000000000000E+00   1.37968006965550E-12
      4.73271650814771E-22  -6.38905830651462E-09  -6.38767862644449E-09  -1.93706637240422E-18
      5.56376779731314E-09
      0.00000000000000E+00  -8.37761770438455E-12   0.00000000000000E+00  -5.63808673954446E-13   2.52311104138741E-22
      8.37818271234768E-09   8.37761890367397E-09  -5.50657518122429E-19  -3.66534752551071E-01  -3.66534752549063E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00764865339182E-09   0.00000000000000E+00  -2.00764865339182E-09
      2.40788532558624E-18  -6.55714298069271E-03  -4.55017694596885E-03   0.00000000000000E+00   8.98385163513579E-13
      3.92566713005233E-22  -6.37086863544605E-09  -6.36997025028214E-09  -1.85722780746381E-18
      5.61376779731314E-09
      0.00000000000000E+00  -7.11714053094846E-12   0.00000000000000E+00  -1.24197832512208E-12   1.85000437685929E-22
      7.11841995409052E-09   7.11717797576559E-09  -5.50341562920100E-19  -3.68169524883840E-01  -3.68169524883143E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97363546100591E-10   0.00000000000000E+00  -6.97363546100591E-10
      2.37301714828121E-18  -6.23560035435709E-03  -4.21292897465000E-03   0.00000000000000E+00  -6.07693286973543E-14
      2.88378606979153E-22  -6.41975366033659E-09  -6.41981442966500E-09  -1.82267558536111E-18
      5.66376779731314E-09
      0.00000000000000E+00  -4.75663893997781E-12   0.00000000000000E+00  -2.34459796959320E-12   1.07495120818963E-22
      4.75898517261545E-09   4.75664057464596E-09  -5.89910917210142E-19  -3.53030163995096E-01  -3.53030163996787E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69071311875164E-09   0.00000000000000E+00   1.69071311875164E-09
      2.45755280421879E-18  -6.52392119676741E-03  -4.49257297088358E-03   0.00000000000000E+00  -1.90858590298762E-12
      1.60675075817710E-22  -6.44544510749475E-09  -6.44735369339757E-09  -1.86764188700865E-18
      5.71376779731314E-09
      0.00000000000000E+00  -2.05355647922309E-12   0.00000000000000E+00  -2.71348768988316E-12   2.69750948574070E-23
      2.05630157103334E-09   2.05358808334349E-09  -6.79307719905733E-19  -3.16557122859677E-01  -3.16557122863947E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27027770877209E-09   0.00000000000000E+00   4.27027770877209E-09
      2.67106668965740E-18  -8.78059032456498E-03  -6.78815053519032E-03   0.00000000000000E+00  -5.10907282174279E-12
      1.89818024250870E-23  -6.31875671929387E-09  -6.32386579211559E-09  -1.99175896975166E-18
      5.76376779731314E-09
      0.00000000000000E+00  -4.77592633479139E-15   0.00000000000000E+00  -2.10927390531777E-12  -2.62725495604967E-23
      6.87950135870343E-12   4.77022745335939E-12  -8.00315309786054E-19  -2.63982102291534E-01  -2.63982102297298E-01
      0.00000000000000E+00   0.00000000000000E+00   5.76448144714996E-09   0.00000000000000E+00   5.76448144714996E-09
      2.95929076201489E-18  -1.88168822458187E-02  -1.69991854339221E-02   0.00000000000000E+00  -1.05158767625534E-11
     -6.97746859934468E-23  -5.75873579784069E-09  -5.76925167460331E-09  -2.15897545222884E-18
      5.81376779731313E-09
      0.00000000000000E+00   1.55731936409082E-12   0.00000000000000E+00  -1.66691710037369E-12  -4.12413518343505E-23
     -1.55564690827724E-09  -1.55731382537765E-09  -9.22700115507109E-19  -2.06117712350606E-01  -2.06117712356772E-01
      0.00000000000000E+00   0.00000000000000E+00   6.16651429112510E-09   0.00000000000000E+00   6.16651429112510E-09
      3.26761647657115E-18  -4.41335552106190E-02  -4.26813509166837E-02   0.00000000000000E+00  -1.99607666126146E-11
     -8.49187658054579E-23  -4.58923969913478E-09  -4.60920046574748E-09  -2.34491636106404E-18
      5.86376779731313E-09
      0.00000000000000E+00   2.10195865573146E-12   0.00000000000000E+00  -7.01778570194751E-13  -4.41919615322923E-23
     -2.10128828834972E-09  -2.10199006691996E-09  -1.03618413559986E-18  -1.48307573540543E-01  -1.48307573546375E-01
      0.00000000000000E+00   0.00000000000000E+00   5.83191777133091E-09   0.00000000000000E+00   5.83191777133091E-09
      3.55921236513770E-18  -7.73273692593423E-02  -7.61521915156190E-02   0.00000000000000E+00  -3.35498852898902E-11
     -9.39292161465560E-23  -3.69637781912096E-09  -3.72992770441095E-09  -2.52302822953784E-18
      5.91376779731313E-09
      0.00000000000000E+00   1.99440846846144E-12   0.00000000000000E+00  -8.88381437764710E-14  -4.56412237878162E-23
     -1.99430411104899E-09  -1.99439294919282E-09  -1.13534509705554E-18  -9.43849327833522E-02  -9.43849327884799E-02
      0.00000000000000E+00   0.00000000000000E+00   5.12766114842747E-09   0.00000000000000E+00   5.12766114842747E-09
      3.81559542255907E-18  -1.12428707620376E-01  -1.11441515180603E-01   0.00000000000000E+00  -4.83471275738270E-11
     -1.03701786140874E-22  -3.08492107166071E-09  -3.13326819923464E-09  -2.68025032550353E-18
      5.96376779731313E-09
      0.00000000000000E+00   1.53968517454698E-12   0.00000000000000E+00   2.61514129566300E-13  -4.68581982061683E-23
     -1.53994485236390E-09  -1.53968333823438E-09  -1.20990115191453E-18  -5.15253649946006E-02  -5.15253649986951E-02
      0.00000000000000E+00   0.00000000000000E+00   4.09456740055433E-09   0.00000000000000E+00   4.09456740055433E-09
      4.02032379258679E-18  -1.47939367083897E-01  -1.47134403191873E-01   0.00000000000000E+00  -5.83811605762010E-11
     -1.12902021154131E-22  -2.49650290174362E-09  -2.55488406231993E-09  -2.81042264067225E-18
      6.01376779731313E-09
      0.00000000000000E+00   8.54798969190452E-13   0.00000000000000E+00   5.61852812250114E-13  -4.74935456083199E-23
     -8.55330327491659E-10  -8.54768474679457E-10  -1.24993017801697E-18  -2.76089917874030E-02  -2.76089917901261E-02
      0.00000000000000E+00   0.00000000000000E+00   2.72314869468226E-09   0.00000000000000E+00   2.72314869468226E-09
      4.15648122732090E-18  -1.82974268310937E-01  -1.82385599078663E-01   0.00000000000000E+00  -5.59872198294497E-11
     -1.20487023859980E-22  -1.81239300017325E-09  -1.86838022000282E-09  -2.90655104930393E-18
      6.06376779731313E-09
      0.00000000000000E+00   3.97320333159761E-13   0.00000000000000E+00   4.05509295272296E-13  -4.77296207333196E-23
     -3.97684249454730E-10  -3.97278740159505E-10  -1.26709157680169E-18  -1.71869300040686E-02  -1.71869300057504E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68177193112985E-09   0.00000000000000E+00   1.68177193112985E-09
      4.24056982387739E-18  -2.12936565417862E-01  -2.12531861134945E-01   0.00000000000000E+00  -4.51985481808075E-11
     -1.26013755233792E-22  -1.23929464278940E-09  -1.28449319097034E-09  -2.97347824707570E-18
      6.11376779731313E-09
      0.00000000000000E+00   2.13722703481915E-13   0.00000000000000E+00   1.64333623311121E-13  -4.78169147743876E-23
     -2.13874515616621E-10  -2.13710181993358E-10  -1.27512140696718E-18  -1.24162485119728E-02  -1.24162485130598E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08702755322369E-09   0.00000000000000E+00   1.08702755322369E-09
      4.29492120153857E-18  -2.34757415804507E-01  -2.34482261374178E-01   0.00000000000000E+00  -3.25403435889060E-11
     -1.29732186389641E-22  -8.40777027641304E-10  -8.73317371230340E-10  -3.01979979457140E-18
      6.16376779731313E-09
      0.00000000000000E+00   1.46216821634383E-13   0.00000000000000E+00   6.04570405108267E-14  -4.78518570542784E-23
     -1.46288188012940E-10  -1.46227730972477E-10  -1.27982409398533E-18  -9.80985931407057E-03  -9.80985931482200E-03
      0.00000000000000E+00   0.00000000000000E+00   7.51432373070608E-10   0.00000000000000E+00   7.51432373070608E-10
      4.33249282019211E-18  -2.49452508920608E-01  -2.49261830085700E-01   0.00000000000000E+00  -2.17499622372098E-11
     -1.32115557637205E-22  -5.83454679860788E-10  -6.05204642098129E-10  -3.05266872620678E-18
      6.21376779731313E-09
      0.00000000000000E+00   1.16367282041936E-13   0.00000000000000E+00   2.76706766086163E-14  -4.78639867422306E-23
     -1.16404079336164E-10  -1.16376408659603E-10  -1.28307861228052E-18  -8.15423403857559E-03  -8.15423403915406E-03
      0.00000000000000E+00   0.00000000000000E+00   5.78466402190870E-10   0.00000000000000E+00   5.78466402190870E-10
      4.36141614030165E-18  -2.60081088392505E-01  -2.59935501636667E-01   0.00000000000000E+00  -1.53387246512961E-11
     -1.33748664411992E-22  -4.46751268879848E-10  -4.62089993531278E-10  -3.07833752802112E-18
      6.26376779731313E-09
      0.00000000000000E+00   9.96515398701665E-14   0.00000000000000E+00   1.69095265244755E-14  -4.78637987820993E-23
     -9.96816799283374E-11  -9.96647704018608E-11  -1.28554057331647E-18  -7.00431156431531E-03  -7.00431156480115E-03
      0.00000000000000E+00   0.00000000000000E+00   4.85840003500719E-10   0.00000000000000E+00   4.85840003500719E-10
      4.38570814047669E-18  -2.68544155614908E-01  -2.68422487910670E-01   0.00000000000000E+00  -1.17818128092353E-11
     -1.34975036304300E-22  -3.74393420289493E-10  -3.86175233098864E-10  -3.10016756716022E-18
      6.31376779731313E-09
      0.00000000000000E+00   8.74361898215655E-14   0.00000000000000E+00   1.40187514784290E-14  -4.78548582639430E-23
     -8.74201381595483E-11  -8.74061194081177E-11  -1.28743286037058E-18  -6.19723081460890E-03  -6.19723081504361E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34703606002494E-10   0.00000000000000E+00   4.34703606002494E-10
      4.40744332077681E-18  -2.75992451217024E-01  -2.75883033050915E-01   0.00000000000000E+00  -9.99629201339212E-12
     -1.35994962982130E-22  -3.37301194580837E-10  -3.47297486594365E-10  -3.12001046040623E-18
      6.36376779731313E-09
      0.00000000000000E+00   7.61392871450397E-14   0.00000000000000E+00   1.44049017928183E-14  -4.78379243471807E-23
     -7.61634786385477E-11  -7.61490737368027E-11  -1.28880915195457E-18  -5.65743653321077E-03  -5.65743653364287E-03
      0.00000000000000E+00   0.00000000000000E+00   4.32104439674679E-10   0.00000000000000E+00   4.32104439674679E-10
      4.42904854276054E-18  -2.84090121771620E-01  -2.83977975682765E-01   0.00000000000000E+00  -1.09309949226078E-11
     -1.37085446635368E-22  -3.45024371015137E-10  -3.55955365937882E-10  -3.14023939080598E-18
      6.41376779731313E-09
      0.00000000000000E+00   6.24544213011182E-14   0.00000000000000E+00   1.85891903791237E-14  -4.78107524531486E-23
     -6.24611736924966E-11  -6.24425845021653E-11  -1.28955723683349E-18  -5.37545764745725E-03  -5.37545764796136E-03
      0.00000000000000E+00   0.00000000000000E+00   5.04105906200112E-10   0.00000000000000E+00   5.04105906200112E-10
      4.45425383807055E-18  -2.95694969428559E-01  -2.95555818537152E-01   0.00000000000000E+00  -1.67713836805232E-11
     -1.38715072969848E-22  -4.24891938017280E-10  -4.41663321697942E-10  -3.16469660123706E-18
      6.46376779731313E-09
      0.00000000000000E+00   4.72081949246687E-14   0.00000000000000E+00   2.20509679065627E-14  -4.77723205954312E-23
     -4.72726081408000E-11  -4.72505571729412E-11  -1.28961243384769E-18  -5.41594094082072E-03  -5.41594094136947E-03
      0.00000000000000E+00   0.00000000000000E+00   5.48756770147318E-10   0.00000000000000E+00   5.48756770147318E-10
      4.48169167657791E-18  -3.09910340847648E-01  -3.09752334760178E-01   0.00000000000000E+00  -2.13763073614738E-11
     -1.40740301433899E-22  -4.80129905612727E-10  -5.01506212974341E-10  -3.19207924273023E-18
      6.51376779731313E-09
      0.00000000000000E+00   7.80680266263977E-15   0.00000000000000E+00   5.18664257199842E-14  -4.77004126940998E-23
     -7.87850860704219E-12  -7.82664218136990E-12  -1.28777884979317E-18  -6.55637406014022E-03  -6.55637406062754E-03
      0.00000000000000E+00   0.00000000000000E+00   4.87318836288408E-10   0.00000000000000E+00   4.87318836288408E-10
      4.50605761839233E-18  -3.24404585133757E-01  -3.24253515388274E-01   0.00000000000000E+00  -2.07257003892212E-11
     -1.42657595908242E-22  -4.58766493717693E-10  -4.79492194107057E-10  -3.21827876859916E-18
      6.56376779731313E-09
      0.00000000000000E+00  -1.61187513799209E-13   0.00000000000000E+00   2.05866478118288E-13  -4.74777641797567E-23
      1.60976303454843E-10   1.61182169932914E-10  -1.27766128801076E-18  -1.25850930826162E-02  -1.25850930828074E-02
      0.00000000000000E+00   0.00000000000000E+00   1.91133875526186E-10   0.00000000000000E+00   1.91133875526186E-10
      4.51561431216865E-18  -3.38746010406336E-01  -3.38635011844748E-01   0.00000000000000E+00  -1.21815467087601E-11
     -1.43774810532077E-22  -3.40134498750202E-10  -3.52316045459105E-10  -3.23795302415789E-18
      6.61376779731313E-09
      0.00000000000000E+00  -6.71936097410266E-13   0.00000000000000E+00   6.14181575301622E-13  -4.68129811528190E-23
      6.71354441262935E-10   6.71968622838190E-10  -1.24264650240920E-18  -3.29568459172865E-02  -3.29568459166396E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.46874751336896E-10   0.00000000000000E+00  -6.46874751336896E-10
      4.48327057460180E-18  -3.54031077166335E-01  -3.54023181532444E-01   0.00000000000000E+00   1.18839702101275E-11
     -1.42745147831954E-22  -3.69778417112715E-11  -2.50938715012868E-11  -3.24062407219260E-18
      6.66376779731313E-09
      0.00000000000000E+00  -1.14530387297786E-12   0.00000000000000E+00   6.28108222850609E-13  -4.58386248590861E-23
      1.14469638133987E-09   1.14532448956267E-09  -1.18622211975129E-18  -6.46085179179604E-02  -6.46085179165954E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.36500024541650E-09   0.00000000000000E+00  -1.36500024541650E-09
      4.41502056233098E-18  -3.69461603122401E-01  -3.69530835993327E-01   0.00000000000000E+00   3.03236843372669E-11
     -1.39984402273694E-22   1.89352071516701E-10   2.19675755853828E-10  -3.22879844257968E-18
      6.71376779731313E-09
      0.00000000000000E+00  -1.46014763212526E-12   0.00000000000000E+00   4.53502546751716E-13  -4.46751933973048E-23
      1.45963913762342E-09   1.46009264017012E-09  -1.12099613564381E-18  -9.95438624100555E-02  -9.95438624083801E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.67539520616508E-09   0.00000000000000E+00  -1.67539520616508E-09
      4.33125080202272E-18  -3.83515574908464E-01  -3.83583434051171E-01   0.00000000000000E+00   3.54996025666012E-11
     -1.36556206292722E-22   1.79802963428495E-10   2.15302565994960E-10  -3.21025466637892E-18
      6.73876779731313E-09
      0.00000000000000E+00  -1.69765812254392E-12   0.00000000000000E+00   5.98292142290876E-13  -4.36852883880293E-23
      1.69708283368671E-09   1.69768112582896E-09  -1.08626867949858E-18  -1.17486392002736E-01  -1.17486392000907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82835773260165E-09   0.00000000000000E+00  -1.82835773260165E-09
      4.28554185870768E-18  -3.89952940036380E-01  -3.89994142943902E-01   0.00000000000000E+00   3.65200149940012E-11
     -1.34699990908826E-22   9.41565917787715E-11   1.30676606772638E-10  -3.19927317920910E-18
      6.77251779731313E-09
      0.00000000000000E+00  -2.13970684272375E-12   0.00000000000000E+00   7.63802603333016E-13  -4.06879090456686E-23
      2.13890560011683E-09   2.13966940272012E-09  -1.03767992286408E-18  -1.41846124897645E-01  -1.41846124895678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96727919468414E-09   0.00000000000000E+00  -1.96727919468414E-09
      4.21914618588709E-18  -3.96997705885363E-01  -3.96943439402388E-01   0.00000000000000E+00   3.82383002015952E-11
     -1.31938956964256E-22  -2.10628508237446E-10  -1.72390208035983E-10  -3.18146626302301E-18
      6.81808029731313E-09
      0.00000000000000E+00  -3.39109138717630E-12   0.00000000000000E+00   1.45555122127447E-12  -2.79534968813678E-23
      3.38965219125543E-09   3.39110774247667E-09  -9.69702275791495E-19  -1.74549475686060E-01  -1.74549475683828E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23263929976650E-09   0.00000000000000E+00  -2.23263929976650E-09
      4.11742155779148E-18  -4.00552444782405E-01  -4.00187543881391E-01   0.00000000000000E+00   4.32451157466511E-11
     -1.27387841641174E-22  -1.20171355845671E-09  -1.15846844271018E-09  -3.14771928199999E-18
      6.86808029731313E-09
      0.00000000000000E+00  -5.98993007120048E-12   0.00000000000000E+00   2.63772018659972E-12   8.95507754662971E-24
      5.98726137952471E-09   5.98989909971132E-09  -9.00209396999160E-19  -2.06523738973254E-01  -2.06523738970737E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.51687552112093E-09   0.00000000000000E+00  -2.51687552112093E-09
      3.99157778173543E-18  -3.89818804970174E-01  -3.88724745173177E-01   0.00000000000000E+00   4.98623991214504E-11
     -1.21002000562433E-22  -3.52288597771169E-09  -3.47302357859036E-09  -3.09136838473627E-18
      6.91808029731313E-09
      0.00000000000000E+00  -9.30120838174344E-12   0.00000000000000E+00   3.31341864590015E-12   6.01921105593862E-23
      9.29792614810505E-09   9.30123956675101E-09  -8.46193768972334E-19  -2.30739286991949E-01  -2.30739286989228E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72062836966744E-09   0.00000000000000E+00  -2.72062836966744E-09
      3.85554636325206E-18  -3.57974405780392E-01  -3.55901311718408E-01   0.00000000000000E+00   5.39727538377867E-11
     -1.13422877869526E-22  -6.63458395092127E-09  -6.58061119708360E-09  -3.00935259427973E-18
      6.96808029731313E-09
      0.00000000000000E+00  -1.18137130127925E-11   0.00000000000000E+00   2.50743302526283E-12   1.01073369115518E-22
      1.18112481469991E-08   1.18137555800244E-08  -8.10264442050043E-19  -2.47068493115758E-01  -2.47068493112893E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86459363999411E-09   0.00000000000000E+00  -2.86459363999411E-09
      3.71231668125235E-18  -3.06572954590194E-01  -3.03753605855554E-01   0.00000000000000E+00   5.15707208753955E-11
     -1.05669878166732E-22  -9.00073266090561E-09  -8.94916194003032E-09  -2.90205223920231E-18
      7.01808029731313E-09
      0.00000000000000E+00  -1.29932749727488E-11   0.00000000000000E+00   1.18046054453089E-12   1.21101759541521E-22
      1.29921068342585E-08   1.29932872948031E-08  -7.86996580536725E-19  -2.58256674428693E-01  -2.58256674425761E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93187442888926E-09   0.00000000000000E+00  -2.93187442888926E-09
      3.56572295980789E-18  -2.46101589565570E-01  -2.42931758047344E-01   0.00000000000000E+00   4.14039577099575E-11
     -9.77843289408679E-23  -1.01028168236237E-08  -1.00614128659138E-08  -2.77872637927117E-18
      7.06808029731313E-09
      0.00000000000000E+00  -1.33553269268209E-11   0.00000000000000E+00   3.68409636562549E-13   1.26097853108585E-22
      1.33549813348733E-08   1.33553497445100E-08  -7.69952789584096E-19  -2.67047255260725E-01  -2.67047255257796E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92866166066631E-09   0.00000000000000E+00  -2.92866166066631E-09
      3.41928987677458E-18  -1.85821797278013E-01  -1.82536825353165E-01   0.00000000000000E+00   2.99272215010808E-11
     -9.06052572277188E-23  -1.04566153053447E-08  -1.04266880838437E-08  -2.64933708719048E-18
      7.11808029731313E-09
      0.00000000000000E+00  -1.32675233580505E-11   0.00000000000000E+00  -7.82982752997661E-14   1.23058192126238E-22
      1.32675831103818E-08   1.32675048121066E-08  -7.56381885283575E-19  -2.74575264271172E-01  -2.74575264268273E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89914554822579E-09   0.00000000000000E+00  -2.89914554822579E-09
      3.27433259936329E-18  -1.28285151077825E-01  -1.25018513214555E-01   0.00000000000000E+00   2.18253440773479E-11
     -8.48404156347649E-23  -1.03901846079581E-08  -1.03683592638808E-08  -2.51795071407971E-18
      7.14308029731313E-09
      0.00000000000000E+00  -1.30403913229363E-11   0.00000000000000E+00  -4.40774620175254E-13   1.19561743944598E-22
      1.30407871704617E-08   1.30403463958416E-08  -7.50452508848187E-19  -2.78031941591955E-01  -2.78031941589068E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88664182491711E-09   0.00000000000000E+00  -2.88664182491711E-09
      3.20216655374036E-18  -1.00826996474789E-01  -9.76279700744750E-02   0.00000000000000E+00   1.74298944288707E-11
     -8.10157387493462E-23  -1.01711344653533E-08  -1.01537045709245E-08  -2.45171404489217E-18
      7.17683029731313E-09
      0.00000000000000E+00  -1.26815539346665E-11   0.00000000000000E+00  -5.08878420594527E-13   1.16053127197294E-22
      1.26820625738271E-08   1.26815536954067E-08  -7.41556649706315E-19  -2.83069572671932E-01  -2.83069572669105E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.82694928842213E-09   0.00000000000000E+00  -2.82694928842213E-09
      3.10675701525611E-18  -6.81523167499867E-02  -6.50475095437765E-02   0.00000000000000E+00   1.37308274601405E-11
     -6.59723719937648E-23  -9.86833523444460E-09  -9.85460440698453E-09  -2.36520036554980E-18
      7.22239279731313E-09
      0.00000000000000E+00  -1.17240725492780E-11   0.00000000000000E+00  -1.02298716686446E-12   1.19492416335248E-22
      1.17250829471126E-08   1.17240599599458E-08  -7.23275834315958E-19  -2.92184142611937E-01  -2.92184142609263E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67373439154306E-09   0.00000000000000E+00  -2.67373439154306E-09
      2.98493499204143E-18  -3.75155997116278E-02  -3.46641723907513E-02   0.00000000000000E+00   9.37023090978188E-12
     -1.12770212416881E-24  -9.05969579931260E-09  -9.05032556840282E-09  -2.26165915772547E-18
      7.27239279731313E-09
      0.00000000000000E+00  -1.04279596178054E-11   0.00000000000000E+00  -1.25980142876398E-12   1.37067372556837E-22
      1.04291970265093E-08   1.04279372250807E-08  -6.93580949444844E-19  -3.05611557156910E-01  -3.05611557154455E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45442728391013E-09   0.00000000000000E+00  -2.45442728391013E-09
      2.86221362784592E-18  -2.11670761421272E-02  -1.86549048683448E-02   0.00000000000000E+00   5.70441325109962E-12
      9.56861944016491E-23  -7.97921435442177E-09  -7.97350994117057E-09  -2.16863267840108E-18
      7.32239279731313E-09
      0.00000000000000E+00  -9.53752489057841E-12   0.00000000000000E+00  -8.59739791900355E-13   1.57605661425127E-22
      9.53838700924386E-09   9.53752726945212E-09  -6.60511464109577E-19  -3.20143301434374E-01  -3.20143301432082E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29162692949017E-09   0.00000000000000E+00  -2.29162692949017E-09
      2.74763228137142E-18  -1.40612645978139E-02  -1.17783321068689E-02   0.00000000000000E+00   3.53702848448758E-12
      1.73033192781328E-22  -7.24943736844659E-09  -7.24590033996193E-09  -2.08712081726184E-18
      7.37239279731313E-09
      0.00000000000000E+00  -9.02484756748599E-12   0.00000000000000E+00  -4.88728318014621E-13   1.71229647209634E-22
      9.02535205251874E-09   9.02486332420090E-09  -6.28115921412696E-19  -3.34376654282972E-01  -3.34376654280768E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.20394762166335E-09   0.00000000000000E+00  -2.20394762166335E-09
      2.63743490028825E-18  -1.05601472225265E-02  -8.41110944919899E-03   0.00000000000000E+00   2.46601689664632E-12
      2.23704280634964E-22  -6.82338171943442E-09  -6.82091570253755E-09  -2.00931897887555E-18
      7.42239279731313E-09
      0.00000000000000E+00  -8.83188177461298E-12   0.00000000000000E+00  -1.74298149875371E-13   1.76388890760098E-22
      8.83203633285645E-09   8.83186203470675E-09  -5.95506663614224E-19  -3.48773584075077E-01  -3.48773584072822E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25495587781384E-09   0.00000000000000E+00  -2.25495587781384E-09
      2.52468710639756E-18  -8.53077026780839E-03  -6.45860923798611E-03   0.00000000000000E+00   1.99480050884308E-12
      2.51558021629784E-22  -6.57890095740201E-09  -6.57690615689292E-09  -1.92918044278333E-18
      7.47239279731313E-09
      0.00000000000000E+00  -8.91536864073462E-12   0.00000000000000E+00   1.00942195367958E-13   1.73494107961286E-22
      8.91524646444663E-09   8.91534740664217E-09  -5.60471327328689E-19  -3.64224849143926E-01  -3.64224849141471E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45423582057492E-09   0.00000000000000E+00  -2.45423582057492E-09
      2.40197531536881E-18  -7.20516145217366E-03  -5.16948211294070E-03   0.00000000000000E+00   1.80283449821126E-12
      2.60458443070656E-22  -6.46291442056571E-09  -6.46111158606724E-09  -1.84150398804012E-18
      7.52239279731313E-09
      0.00000000000000E+00  -8.86457850105886E-12   0.00000000000000E+00  -3.50480039858397E-14   1.57677376357998E-22
      8.86461534095641E-09   8.86458029295259E-09  -5.26440626057029E-19  -3.79238448334651E-01  -3.79238448332189E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46194750349512E-09   0.00000000000000E+00  -2.46194750349512E-09
      2.27887794019406E-18  -6.26594580639823E-03  -4.24868846507748E-03   0.00000000000000E+00   1.56396668834540E-12
      2.44019077162550E-22  -6.40419675614608E-09  -6.40263278945749E-09  -1.75243731413703E-18
      7.54739279731313E-09
      0.00000000000000E+00  -8.77337667701178E-12   0.00000000000000E+00  -1.66130947375218E-13   1.45040909046673E-22
      8.77355039955243E-09   8.77338426860520E-09  -5.10212712449246E-19  -3.86390954146875E-01  -3.86390954144473E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40131670188696E-09   0.00000000000000E+00  -2.40131670188696E-09
      2.21884502264688E-18  -5.88785074128173E-03  -3.88022255738425E-03   0.00000000000000E+00   1.41230733424779E-12
      2.26601808407932E-22  -6.37347987405264E-09  -6.37206756671817E-09  -1.70863231019763E-18
      7.58114279731313E-09
      0.00000000000000E+00  -8.56323591828096E-12   0.00000000000000E+00  -2.95075632341281E-13   1.24800637481543E-22
      8.56357864178845E-09   8.56328356615623E-09  -4.90564445693790E-19  -3.95058829444133E-01  -3.95058829441937E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19584490091707E-09   0.00000000000000E+00  -2.19584490091707E-09
      2.14473525724093E-18  -5.48734452045199E-03  -3.48117361671151E-03   0.00000000000000E+00   1.17359788683086E-12
      1.96521368688302E-22  -6.36861226312624E-09  -6.36743866523921E-09  -1.65417081154714E-18
      7.62670529731313E-09
      0.00000000000000E+00  -8.04908907939323E-12   0.00000000000000E+00  -5.48070691395000E-13   9.52978212462478E-23
      8.04964827500594E-09   8.04910020431464E-09  -4.71511316422007E-19  -4.03548497430521E-01  -4.03548497428869E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65257512185095E-09   0.00000000000000E+00  -1.65257512185095E-09
      2.06943980325159E-18  -5.10489036007302E-03  -3.08955398780096E-03   0.00000000000000E+00   7.76106559929643E-13
      1.50315856271189E-22  -6.39730118902379E-09  -6.39652508246371E-09  -1.59792848682959E-18
      7.67670529731313E-09
      0.00000000000000E+00  -6.77272276642023E-12   0.00000000000000E+00  -1.25775285413670E-12   6.32164632404186E-23
      6.77399891798558E-09   6.77274116513151E-09  -4.71503749609579E-19  -4.04163780370489E-01  -4.04163780370195E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93754960987471E-10   0.00000000000000E+00  -2.93754960987471E-10
      2.05475205520222E-18  -4.87031164390362E-03  -2.82899347262907E-03   0.00000000000000E+00  -6.17701370021831E-14
      9.82522481881089E-23  -6.47892443400713E-09  -6.47898620414403E-09  -1.58324830559264E-18
      7.72670529731313E-09
      0.00000000000000E+00  -4.31403915137474E-12   0.00000000000000E+00  -2.43865207979162E-12   3.11188247525563E-23
      4.31649515966298E-09   4.31405650758322E-09  -5.12826004720726E-19  -3.87959505930710E-01  -3.87959505932912E-01
      0.00000000000000E+00   0.00000000000000E+00   2.20148129144922E-09   0.00000000000000E+00   2.20148129144922E-09
      2.16482611977468E-18  -4.86551023305774E-03  -2.81267581434720E-03   0.00000000000000E+00  -1.61190390038903E-12
      4.41462224841986E-23  -6.51392589513208E-09  -6.51553779903243E-09  -1.65200011505396E-18
      7.77670529731313E-09
      0.00000000000000E+00  -1.56402402990697E-12   0.00000000000000E+00  -2.75202286927928E-12  -4.84989190999445E-24
      1.56680144935517E-09   1.56404942648588E-09  -6.07198776239190E-19  -3.50204350465410E-01  -3.50204350470295E-01
      0.00000000000000E+00   0.00000000000000E+00   4.88486628272510E-09   0.00000000000000E+00   4.88486628272510E-09
      2.40906943391094E-18  -5.77770079417753E-03  -3.74585872665473E-03   0.00000000000000E+00  -4.28653690470653E-12
     -2.06789669376481E-23  -6.44462917230626E-09  -6.44891570921099E-09  -1.80187065767175E-18
      7.82670529731313E-09
      0.00000000000000E+00   1.94894532354372E-13   0.00000000000000E+00  -1.81638758787869E-12  -3.25249352594692E-23
     -1.93066028570600E-10  -1.94882416158511E-10  -7.39576886035050E-19  -2.94917167359945E-01  -2.94917167366272E-01
      0.00000000000000E+00   0.00000000000000E+00   6.32703412713627E-09   0.00000000000000E+00   6.32703412713627E-09
      2.72542114026775E-18  -1.10108019450323E-02  -9.07876452099483E-03   0.00000000000000E+00  -8.68569068839528E-12
     -6.87757356876859E-23  -6.12346602028930E-09  -6.13215171097776E-09  -1.98584425423270E-18
      7.87670529731313E-09
      0.00000000000000E+00   1.43231867675138E-12   0.00000000000000E+00  -1.31281357964936E-12  -4.12886847730803E-23
     -1.43096615460983E-09  -1.43227896818952E-09  -8.74061083100512E-19  -2.33697339613268E-01  -2.33697339619829E-01
      0.00000000000000E+00   0.00000000000000E+00   6.56108472096649E-09   0.00000000000000E+00   6.56108472096649E-09
      3.05347537631608E-18  -3.02211089957989E-02  -2.86052029580558E-02   0.00000000000000E+00  -1.62706937962822E-11
     -8.15541436960679E-23  -5.11253505898063E-09  -5.12880575277700E-09  -2.17941429321557E-18
      7.92670529731313E-09
      0.00000000000000E+00   2.12390954792406E-12   0.00000000000000E+00  -8.36384120789521E-13  -4.35292843893332E-23
     -2.12304240537525E-09  -2.12387878949608E-09  -9.94797870281291E-19  -1.73813263848474E-01  -1.73813263854654E-01
      0.00000000000000E+00   0.00000000000000E+00   6.18036152267116E-09   0.00000000000000E+00   6.18036152267116E-09
      3.36249345244963E-18  -6.15839153308286E-02  -6.03058516416383E-02   0.00000000000000E+00  -2.82676410118118E-11
     -9.03134466421514E-23  -4.02821509216318E-09  -4.05648273317508E-09  -2.36769558216834E-18
      7.97670529731313E-09
      0.00000000000000E+00   2.11564352157538E-12   0.00000000000000E+00  -1.79923485844375E-13  -4.51257340459927E-23
     -2.11544385349861E-09  -2.11562377698450E-09  -1.10105068390604E-18  -1.17288746043397E-01  -1.17288746048889E-01
      0.00000000000000E+00   0.00000000000000E+00   5.49160180697597E-09   0.00000000000000E+00   5.49160180697597E-09
      3.63707354279843E-18  -9.66670084646150E-02  -9.56033468437621E-02   0.00000000000000E+00  -4.31094489483442E-11
     -1.00027653175422E-22  -3.33286858104300E-09  -3.37597802999145E-09  -2.53602285889240E-18
      8.02670529731313E-09
      0.00000000000000E+00   1.78757412027009E-12   0.00000000000000E+00   1.21514146450671E-13  -4.65616980983761E-23
     -1.78769374610424E-09  -1.78757223195784E-09  -1.18782554779241E-18  -6.82315872745693E-02  -6.82315872791842E-02
      0.00000000000000E+00   0.00000000000000E+00   4.61482385914271E-09   0.00000000000000E+00   4.61482385914271E-09
      3.86781473575557E-18  -1.32379402609677E-01  -1.31488625100558E-01   0.00000000000000E+00  -5.64686635332643E-11
     -1.09569668646034E-22  -2.77078296365150E-09  -2.82725162718488E-09  -2.67998918796316E-18
      8.07670529731313E-09
      0.00000000000000E+00   1.16596893884955E-12   0.00000000000000E+00   4.58630279299520E-13  -4.74572403401044E-23
     -1.16642789759262E-09  -1.16596926731337E-09  -1.24300979275532E-18  -3.55474684256057E-02  -3.55474684289628E-02
      0.00000000000000E+00   0.00000000000000E+00   3.35703604155262E-09   0.00000000000000E+00   3.35703604155262E-09
      4.03566653783320E-18  -1.68430657141351E-01  -1.67740319919775E-01   0.00000000000000E+00  -6.04183814427723E-11
     -1.18146784240883E-22  -2.13064839279634E-09  -2.19106677423923E-09  -2.79265674507788E-18
      8.12670529731313E-09
      0.00000000000000E+00   5.66957562782063E-13   0.00000000000000E+00   5.17949447353827E-13  -4.78199201877669E-23
     -5.67468212095227E-10  -5.66950262647921E-10  -1.26823747106021E-18  -2.01803354701691E-02  -2.01803354722831E-02
      0.00000000000000E+00   0.00000000000000E+00   2.11400475792949E-09   0.00000000000000E+00   2.11400475792949E-09
      4.14136677572967E-18  -2.02018048468879E-01  -2.01530618903871E-01   0.00000000000000E+00  -5.26634828407743E-11
     -1.24775612501609E-22  -1.49439101244069E-09  -1.54705449528158E-09  -2.87312930466947E-18
      8.17670529731313E-09
      0.00000000000000E+00   2.79575380059711E-13   0.00000000000000E+00   2.57797764215824E-13  -4.79458966630032E-23
     -2.79819026547639E-10  -2.79561228783471E-10  -1.27915679915960E-18  -1.35190631724399E-02  -1.35190631737884E-02
      0.00000000000000E+00   0.00000000000000E+00   1.34852814234561E-09   0.00000000000000E+00   1.34852814234561E-09
      4.20879318284695E-18  -2.28564220000318E-01  -2.28227422120215E-01   0.00000000000000E+00  -4.04822029184713E-11
     -1.29455092451292E-22  -1.02848471064356E-09  -1.06896691356216E-09  -2.92963638368735E-18
      8.22670529731313E-09
      0.00000000000000E+00   1.74045777008263E-13   0.00000000000000E+00   9.48984356150511E-14  -4.79914072912638E-23
     -1.74102895984979E-10  -1.74007997549412E-10  -1.28485823706543E-18  -1.01991186178738E-02  -1.01991186187810E-02
      0.00000000000000E+00   0.00000000000000E+00   9.07148994749602E-10   0.00000000000000E+00   9.07148994749602E-10
      4.25415063258443E-18  -2.46896389917570E-01  -2.46665401783814E-01   0.00000000000000E+00  -2.78905099175800E-11
     -1.32507593252575E-22  -7.05250487282465E-10  -7.33140997200177E-10  -2.96929239551900E-18
      8.27670529731313E-09
      0.00000000000000E+00   1.31797197892801E-13   0.00000000000000E+00   3.89546095228070E-14  -4.80059162223125E-23
     -1.31816444254503E-10  -1.31777489645028E-10  -1.28850001359057E-18  -8.26001796181486E-03  -8.26001796246586E-03
      0.00000000000000E+00   0.00000000000000E+00   6.51000680028336E-10   0.00000000000000E+00   6.51000680028336E-10
      4.28670066658585E-18  -2.59065056519110E-01  -2.58901468859591E-01   0.00000000000000E+00  -1.81295607034590E-11
     -1.34427929621628E-22  -5.01093629679710E-10  -5.19223190383303E-10  -2.99820065299529E-18
      8.32670529731313E-09
      0.00000000000000E+00   1.10213684649032E-13   0.00000000000000E+00   2.15819360142349E-14  -4.80051563465234E-23
     -1.10233805192143E-10  -1.10212223256177E-10  -1.29111163087081E-18  -6.99204971223852E-03  -6.99204971276472E-03
      0.00000000000000E+00   0.00000000000000E+00   5.26200952408144E-10   0.00000000000000E+00   5.26200952408144E-10
      4.31301071420626E-18  -2.68254905079275E-01  -2.68123844302351E-01   0.00000000000000E+00  -1.31581713269964E-11
     -1.35787598829402E-22  -4.02830557824825E-10  -4.15988729151957E-10  -3.02189908333545E-18
      8.37670529731313E-09
      0.00000000000000E+00   9.73554214399784E-14   0.00000000000000E+00   1.45245156975973E-14  -4.79960790120709E-23
     -9.74116182671981E-11  -9.73970937515485E-11  -1.29312891328362E-18  -6.09290649698086E-03  -6.09290649744181E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60954586711824E-10   0.00000000000000E+00   4.60954586711824E-10
      4.33605844354185E-18  -2.75965660031035E-01  -2.75851119215802E-01   0.00000000000000E+00  -1.06102457623849E-11
     -1.36861228622394E-22  -3.52947247197749E-10  -3.63557492960271E-10  -3.04292953025823E-18
      8.40170529731313E-09
      0.00000000000000E+00   9.13855135214891E-14   0.00000000000000E+00   1.44541140864622E-14  -4.79895218581903E-23
     -9.14086960552459E-11  -9.13942419412074E-11  -1.29399885056022E-18  -5.73100386420346E-03  -5.73100386463087E-03
      0.00000000000000E+00   0.00000000000000E+00   4.27414612453233E-10   0.00000000000000E+00   4.27414612453233E-10
      4.34674380885318E-18  -2.79415714752700E-01  -2.79309850289474E-01   0.00000000000000E+00  -9.19295496353193E-12
     -1.37321196078555E-22  -3.26827415548365E-10  -3.36020370512035E-10  -3.05274495829296E-18
      8.41858029731313E-09
      0.00000000000000E+00   8.75280345587730E-14   0.00000000000000E+00   1.43680688910100E-14  -4.79842326049455E-23
     -8.75461745318826E-11  -8.75318064630396E-11  -1.29452608519867E-18  -5.52100152461893E-03  -5.52100152503540E-03
      0.00000000000000E+00   0.00000000000000E+00   4.16474427910329E-10   0.00000000000000E+00   4.16474427910329E-10
      4.35377181482417E-18  -2.81700286855058E-01  -2.81596652423165E-01   0.00000000000000E+00  -8.92304735603440E-12
     -1.37619902506353E-22  -3.20019574091142E-10  -3.28942621447314E-10  -3.05924572962550E-18
      8.44136154731313E-09
      0.00000000000000E+00   8.33031766472268E-14   0.00000000000000E+00   1.26962366701881E-14  -4.79759459155208E-23
     -8.33199754661175E-11  -8.33072792294952E-11  -1.29515134209456E-18  -5.28018899283639E-03  -5.28018899325374E-03
      0.00000000000000E+00   0.00000000000000E+00   4.17347606870667E-10   0.00000000000000E+00   4.17347606870667E-10
      4.36327951499319E-18  -2.84928005942196E-01  -2.84822765312391E-01   0.00000000000000E+00  -9.41150579570114E-12
     -1.38040762945957E-22  -3.24628821845368E-10  -3.34040327641208E-10  -3.06812817289863E-18
      8.47211623481313E-09
      0.00000000000000E+00   7.76088029403601E-14   0.00000000000000E+00   1.33900199706651E-14  -4.79625104070161E-23
     -7.75846133625134E-11  -7.75712233425907E-11  -1.29583793387722E-18  -5.02133829128125E-03  -5.02133829171978E-03
      0.00000000000000E+00   0.00000000000000E+00   4.38530704985444E-10   0.00000000000000E+00   4.38530704985444E-10
      4.37676638978417E-18  -2.89991265379073E-01  -2.89877543054600E-01   0.00000000000000E+00  -1.13341510848579E-11
     -1.38715376652005E-22  -3.49625330557875E-10  -3.60959481642871E-10  -3.08092845590696E-18
      8.51363506293813E-09
      0.00000000000000E+00   6.87917081684375E-14   0.00000000000000E+00   1.56270886677162E-14  -4.79394448312193E-23
     -6.88049693786942E-11  -6.87893422900744E-11  -1.29643984255474E-18  -4.78253332297067E-03  -4.78253332347741E-03
      0.00000000000000E+00   0.00000000000000E+00   5.06736854665718E-10   0.00000000000000E+00   5.06736854665718E-10
      4.39780551015764E-18  -2.99368762746200E-01  -2.99230783038219E-01   0.00000000000000E+00  -1.66772831168759E-11
     -1.40030077428429E-22  -4.21270229258648E-10  -4.37947512375664E-10  -3.10136566760291E-18
      8.56363506293813E-09
      0.00000000000000E+00   5.92398554988548E-14   0.00000000000000E+00   1.57445681457518E-14  -4.79056350219306E-23
     -5.92605693310904E-11  -5.92448247629925E-11  -1.29675207379678E-18  -4.64801742990953E-03  -4.64801743047427E-03
      0.00000000000000E+00   0.00000000000000E+00   5.64745982942982E-10   0.00000000000000E+00   5.64745982942982E-10
      4.42604280930479E-18  -3.13405292831822E-01  -3.13246028450452E-01   0.00000000000000E+00  -2.18445647164641E-11
     -1.42057016874481E-22  -4.83656593463398E-10  -5.05501158180004E-10  -3.12929073550801E-18
      8.61363506293813E-09
      0.00000000000000E+00   4.16975106922171E-14   0.00000000000000E+00   2.60528266937859E-14  -4.78583128419073E-23
     -4.17417681331306E-11  -4.17157153064847E-11  -1.29625801789285E-18  -4.96569291749312E-03  -4.96569291804047E-03
      0.00000000000000E+00   0.00000000000000E+00   5.47346835938371E-10   0.00000000000000E+00   5.47346835938371E-10
      4.45341015110171E-18  -3.27947226923764E-01  -3.27787921738442E-01   0.00000000000000E+00  -2.27745265674915E-11
     -1.44116910199025E-22  -4.82856594064239E-10  -5.05631120631875E-10  -3.15715213320886E-18
      8.66363506293813E-09
      0.00000000000000E+00  -3.24211922342569E-14   0.00000000000000E+00   9.35035480029895E-14  -4.77457394736066E-23
      3.22784130640292E-11   3.23719166119844E-11  -1.29215431655212E-18  -7.43231994351545E-03  -7.43231994392262E-03
      0.00000000000000E+00   0.00000000000000E+00   4.07173647935358E-10   0.00000000000000E+00   4.07173647935358E-10
      4.47376883349848E-18  -3.42077337440959E-01  -3.41938854812430E-01   0.00000000000000E+00  -1.87205959023531E-11
     -1.45774604164122E-22  -4.20824968644832E-10  -4.39545564547331E-10  -3.18161451694635E-18
      8.71363506293814E-09
      0.00000000000000E+00  -3.56173890890789E-13   0.00000000000000E+00   3.89523921698687E-13  -4.73434331531258E-23
      3.55810848553429E-10   3.56200372475081E-10  -1.27212092103721E-18  -1.92618719993412E-02  -1.92618719992016E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.39614904382485E-10   0.00000000000000E+00  -1.39614904382485E-10
      4.46678808827935E-18  -3.56543196416982E-01  -3.56474965208575E-01   0.00000000000000E+00  -1.91455684385344E-12
     -1.45965268529415E-22  -2.14670911248622E-10  -2.16585468092621E-10  -3.19466716724215E-18
      8.76363506293814E-09
      0.00000000000000E+00  -9.29560585277378E-13   0.00000000000000E+00   7.07243090569335E-13  -4.64624848954329E-23
      9.28871417846103E-10   9.29578660936626E-10  -1.22445507878243E-18  -4.66431158221824E-02  -4.66431158211214E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.06091970214385E-09   0.00000000000000E+00  -1.06091970214385E-09
      4.41374210317216E-18  -3.71990903033708E-01  -3.72032299151137E-01   0.00000000000000E+00   2.49375724936127E-11
     -1.43819327719055E-22   1.06403468713740E-10   1.31341041207209E-10  -3.18928702438973E-18
      8.81363506293814E-09
      0.00000000000000E+00  -1.28454049458447E-12   0.00000000000000E+00   5.03687122041043E-13  -4.53430004287934E-23
      1.28403317285204E-09   1.28453685997404E-09  -1.16246841535199E-18  -8.07706371760212E-02  -8.07706371744760E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.54524362692107E-09   0.00000000000000E+00  -1.54524362692107E-09
      4.33647992182611E-18  -3.86810538305974E-01  -3.86892699035034E-01   0.00000000000000E+00   3.60542494739327E-11
     -1.40570401249738E-22   2.24652517473295E-10   2.60706766947087E-10  -3.17401150647412E-18
      8.83863506293814E-09
      0.00000000000000E+00  -1.47346511902035E-12   0.00000000000000E+00   5.16010399307612E-13  -4.47768301718700E-23
      1.47293615091736E-09   1.47345216131662E-09  -1.12868737986576E-18  -9.87271767244887E-02  -9.87271767227560E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73263747378139E-09   0.00000000000000E+00  -1.73263747378139E-09
      4.29316398498157E-18  -3.93827681552148E-01  -3.93909366676821E-01   0.00000000000000E+00   3.81989300278332E-11
     -1.38774116728533E-22   2.20986382436997E-10   2.59185312464691E-10  -3.16447660511581E-18
      8.87238506293814E-09
      0.00000000000000E+00  -1.72603814634105E-12   0.00000000000000E+00   5.00221832746324E-13  -4.37468822355493E-23
      1.72554503639288E-09   1.72604525822559E-09  -1.08132546734807E-18  -1.23160534522375E-01  -1.23160534520529E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.84642089739232E-09   0.00000000000000E+00  -1.84642089739232E-09
      4.23084727969458E-18  -4.02237662073962E-01  -4.02275622291524E-01   0.00000000000000E+00   3.90523550216133E-11
     -1.36179561383765E-22   8.13232841452625E-11   1.20375639166740E-10  -3.14952181234651E-18
      8.91794756293814E-09
      0.00000000000000E+00  -2.43021174651116E-12   0.00000000000000E+00   8.76311518378065E-13  -3.99977674209601E-23
      2.42930817079367E-09   2.43018448231201E-09  -1.01454917879308E-18  -1.56218542032992E-01  -1.56218542030954E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.03839455181441E-09   0.00000000000000E+00  -2.03839455181441E-09
      4.13797292792753E-18  -4.10099190111260E-01  -4.09975812017462E-01   0.00000000000000E+00   4.17362919733536E-11
     -1.32164227095230E-22  -4.33526222470761E-10  -3.91789930497539E-10  -3.12342374913445E-18
      8.96794756293814E-09
      0.00000000000000E+00  -4.21466314571620E-12   0.00000000000000E+00   1.85190858596042E-12  -2.51319583907989E-23
      4.21281603173850E-09   4.21466794032444E-09  -9.40101086482033E-19  -1.91289152908791E-01  -1.91289152906449E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34227653438917E-09   0.00000000000000E+00  -2.34227653438917E-09
      4.02085910120808E-18  -4.09311900609660E-01  -4.08722099129599E-01   0.00000000000000E+00   4.77913140820313E-11
     -1.26589590631067E-22  -1.92018272001720E-09  -1.87239140593530E-09  -3.08075801472604E-18
      9.01794756293814E-09
      0.00000000000000E+00  -7.22680314717424E-12   0.00000000000000E+00   3.03395677487908E-12   9.43747535187415E-24
      7.22373034822057E-09   7.22676430499546E-09  -8.75195373873282E-19  -2.20578729228201E-01  -2.20578729225620E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58116893908197E-09   0.00000000000000E+00  -2.58116893908197E-09
      3.89180065425398E-18  -3.91050837112445E-01  -3.89587376720145E-01   0.00000000000000E+00   5.36972702283378E-11
     -1.19562104589798E-22  -4.69929263614172E-09  -4.64559536591350E-09  -3.01660528038070E-18
      9.06794756293814E-09
      0.00000000000000E+00  -1.04286943757030E-11   0.00000000000000E+00   3.19696467933720E-12   4.94980492840627E-23
      1.04254687846204E-08   1.04286657492998E-08  -8.27809647966591E-19  -2.41625406981884E-01  -2.41625406979135E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74907356928903E-09   0.00000000000000E+00  -2.74907356928903E-09
      3.75434697578953E-18  -3.51238049001185E-01  -3.48818720469913E-01   0.00000000000000E+00   5.59192377786076E-11
     -1.11602623373615E-22  -7.73551141778925E-09  -7.67959218001076E-09  -2.92653732782294E-18
      9.11794756293814E-09
      0.00000000000000E+00  -1.24129999230717E-11   0.00000000000000E+00   1.98020550593868E-12   7.59676699259510E-23
      1.24110240613291E-08   1.24130042668351E-08  -7.97444661934515E-19  -2.55506946486441E-01  -2.55506946483574E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86679422586400E-09   0.00000000000000E+00  -2.86679422586400E-09
      3.61100726449633E-18  -2.94506271451699E-01  -2.91498807228092E-01   0.00000000000000E+00   5.05714432112946E-11
     -1.03733222229345E-22  -9.59678148418225E-09  -9.54621004097107E-09  -2.81356260256181E-18
      9.16794756293814E-09
      0.00000000000000E+00  -1.31955170840798E-11   0.00000000000000E+00   7.85912231071955E-13   8.63212944230534E-23
      1.31947416224253E-08   1.31955275346564E-08  -7.77198188272842E-19  -2.65383201136405E-01  -2.65383201133500E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90502682340016E-09   0.00000000000000E+00  -2.90502682340016E-09
      3.46575592332632E-18  -2.32676433595334E-01  -2.29434410994428E-01   0.00000000000000E+00   3.85197561966518E-11
     -9.56197282761624E-23  -1.03290204674529E-08  -1.02905007112563E-08  -2.68855773505348E-18
      9.21794756293814E-09
      0.00000000000000E+00  -1.33454995399397E-11   0.00000000000000E+00   1.57675849566339E-13   8.69176767958175E-23
      1.33453399103811E-08   1.33454975862308E-08  -7.61721032023561E-19  -2.73477099247932E-01  -2.73477099245045E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88734425102271E-09   0.00000000000000E+00  -2.88734425102271E-09
      3.32138871077518E-18  -1.72657638192411E-01  -1.69362740684852E-01   0.00000000000000E+00   2.75522008495318E-11
     -8.88441783649393E-23  -1.04857055360575E-08  -1.04581533352080E-08  -2.55966767875162E-18
      9.23044756293814E-09
      0.00000000000000E+00  -1.32312446868535E-11   0.00000000000000E+00  -4.41747436961523E-13   8.57033451662450E-23
      1.32316554850011E-08   1.32312137375642E-08  -7.58565989634626E-19  -2.75227163841430E-01  -2.75227163838527E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90279040349605E-09   0.00000000000000E+00  -2.90279040349605E-09
      3.28510383073148E-18  -1.57615409737775E-01  -1.54361372052580E-01   0.00000000000000E+00   2.34389355878152E-11
     -8.75024274244302E-23  -1.03518622696560E-08  -1.03284233340682E-08  -2.52653784109686E-18
      9.24732256293814E-09
      0.00000000000000E+00  -1.31503294733737E-11   0.00000000000000E+00  -2.30074367615018E-13   8.39877975722360E-23
      1.31505875140082E-08   1.31503574396407E-08  -7.54378275391648E-19  -2.77582455593946E-01  -2.77582455591061E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88498872653225E-09   0.00000000000000E+00  -2.88498872653225E-09
      3.23641964597125E-18  -1.37954153669009E-01  -1.34719968344220E-01   0.00000000000000E+00   2.08558547114411E-11
     -8.57470549335088E-23  -1.02862245678198E-08  -1.02653687131085E-08  -2.48204137057960E-18
      9.27010381293814E-09
      0.00000000000000E+00  -1.30276249044644E-11   0.00000000000000E+00  -2.58645148156303E-13   8.18654234176635E-23
      1.30279214098327E-08   1.30276627646846E-08  -7.48799746094310E-19  -2.80756264062849E-01  -2.80756264059992E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85695089965606E-09   0.00000000000000E+00  -2.85695089965606E-09
      3.17133473328846E-18  -1.12613067262663E-01  -1.09408688683665E-01   0.00000000000000E+00   1.82319469822731E-11
     -8.31152270453928E-23  -1.01889438120107E-08  -1.01707118650285E-08  -2.42253498719415E-18
      9.30085850043814E-09
      0.00000000000000E+00  -1.27914920851039E-11   0.00000000000000E+00  -3.71315418447693E-13   7.94267103355192E-23
      1.27918346565688E-08   1.27914633411505E-08  -7.41078228822763E-19  -2.85142757609820E-01  -2.85142757607007E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81249644382551E-09   0.00000000000000E+00  -2.81249644382551E-09
      3.08483728406375E-18  -8.12274360963549E-02  -7.80834510191298E-02   0.00000000000000E+00   1.50241538495746E-11
     -7.69387653969785E-23  -9.99399105117444E-09  -9.97896689732495E-09  -2.34375905524099E-18
      9.34237732856314E-09
      0.00000000000000E+00  -1.21332408535375E-11   0.00000000000000E+00  -7.71497929099215E-13   7.93187357197121E-23
      1.21339731363673E-08   1.21332016384383E-08  -7.27361125914869E-19  -2.92297163971718E-01  -2.92297163969012E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.70630574476648E-09   0.00000000000000E+00  -2.70630574476648E-09
      2.97247464099309E-18  -4.78486320540849E-02  -4.48785661184117E-02   0.00000000000000E+00   1.09513261276805E-11
     -4.79559115051321E-23  -9.43784721979937E-09  -9.42689589367174E-09  -2.24511351507822E-18
      9.39237732856314E-09
      0.00000000000000E+00  -1.08565990063529E-11   0.00000000000000E+00  -1.24251442290614E-12   9.04664616890104E-23
      1.08578764327800E-08   1.08566339183572E-08  -7.00706494548686E-19  -3.04539352280477E-01  -3.04539352277984E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.49292269106248E-09   0.00000000000000E+00  -2.49292269106248E-09
      2.84782850643996E-18  -2.56916619314149E-02  -2.30565545380643E-02   0.00000000000000E+00   6.85629584738050E-12
      2.60352087886453E-23  -8.37056752314211E-09  -8.36371122729471E-09  -2.14712201189128E-18
      9.44237732856314E-09
      0.00000000000000E+00  -9.78963869421307E-12   0.00000000000000E+00  -1.03351097889182E-12   1.08679342320563E-22
      9.79071212392456E-09   9.78967861294578E-09  -6.67749602350596E-19  -3.18912577971634E-01  -3.18912577969336E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29892357349562E-09   0.00000000000000E+00  -2.29892357349562E-09
      2.73288232776518E-18  -1.59836311958461E-02  -1.36235548187401E-02   0.00000000000000E+00   4.19459573492743E-12
      9.78142924657599E-23  -7.49494963518518E-09  -7.49075503945016E-09  -2.06513272541459E-18
      9.49237732856314E-09
      0.00000000000000E+00  -9.14727660218363E-12   0.00000000000000E+00  -6.15932339413895E-13   1.24434243419418E-22
      9.14785762117765E-09   9.14724168883836E-09  -6.34354322662587E-19  -3.33321261099952E-01  -3.33321261097778E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17415931557049E-09   0.00000000000000E+00  -2.17415931557049E-09
      2.62417436198666E-18  -1.14771135393200E-02  -9.28013402054511E-03   0.00000000000000E+00   2.79417701950809E-12
      1.50102139057837E-22  -6.97587655028753E-09  -6.97308237326787E-09  -1.98982003932407E-18
      9.54237732856314E-09
      0.00000000000000E+00  -8.79541941394159E-12   0.00000000000000E+00  -3.30783360776106E-13   1.33258081338216E-22
      8.79576760369303E-09   8.79543682033239E-09  -6.01868323778486E-19  -3.47375096621986E-01  -3.47375096619853E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13279955254368E-09   0.00000000000000E+00  -2.13279955254368E-09
      2.51753438435948E-18  -9.01816306442734E-03  -6.91899154176232E-03   0.00000000000000E+00   2.12864984126492E-12
      1.82388534221168E-22  -6.66476591763014E-09  -6.66263726778870E-09  -1.91566606058099E-18
      9.59237732856314E-09
      0.00000000000000E+00  -8.77879551650703E-12   0.00000000000000E+00  -5.12830186440797E-16   1.35912458282856E-22
      8.77875207264289E-09   8.77875155981284E-09  -5.67565381814223E-19  -3.62222772595741E-01  -3.62222772593459E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28128725974365E-09   0.00000000000000E+00  -2.28128725974365E-09
      2.40347002137229E-18  -7.48815117204803E-03  -5.44101794955709E-03   0.00000000000000E+00   1.86372445043530E-12
      1.99130776371439E-22  -6.49932802451984E-09  -6.49746430006920E-09  -1.83590463955807E-18
      9.64237732856314E-09
      0.00000000000000E+00  -8.84703615625222E-12   0.00000000000000E+00   8.30360762109031E-14   1.29736756326524E-22
      8.84698527863810E-09   8.84706831471444E-09  -5.31923043744559E-19  -3.77619611124433E-01  -3.77619611122009E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42419186719713E-09   0.00000000000000E+00  -2.42419186719713E-09
      2.28226042801244E-18  -6.44221557590333E-03  -4.41858051553704E-03   0.00000000000000E+00   1.67960029285269E-12
      1.97728634424723E-22  -6.42455604781033E-09  -6.42287644751728E-09  -1.75033738426787E-18
      9.65487732856314E-09
      0.00000000000000E+00  -8.83978042201283E-12   0.00000000000000E+00  -1.34363775496459E-14   1.26346431495047E-22
      8.83979925279806E-09   8.83978581642063E-09  -5.23074847516698E-19  -3.81433783866529E-01  -3.81433783864076E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45269743286965E-09   0.00000000000000E+00  -2.45269743286965E-09
      2.25160171010157E-18  -6.21294941246992E-03  -4.20058948723211E-03   0.00000000000000E+00   1.64733657481790E-12
      1.93843256734229E-22  -6.38873572012615E-09  -6.38708838355114E-09  -1.72852686258487E-18
      9.67175232856314E-09
      0.00000000000000E+00  -8.80561417977163E-12   0.00000000000000E+00  -8.52598528200573E-14   1.20675690493949E-22
      8.80572011016475E-09   8.80563485031205E-09  -5.11365745359068E-19  -3.86482232976552E-01  -3.86482232974124E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42806352410929E-09   0.00000000000000E+00  -2.42806352410929E-09
      2.21062813813222E-18  -5.95069686487165E-03  -3.94133477599515E-03   0.00000000000000E+00   1.46952818324824E-12
      1.86539748550422E-22  -6.37904085438615E-09  -6.37757132620272E-09  -1.69926239277315E-18
      9.68314295356314E-09
      0.00000000000000E+00  -8.77108055858160E-12   0.00000000000000E+00  -1.35569855725321E-13   1.16145908340436E-22
      8.77122452089263E-09   8.77108895103702E-09  -5.03624324279815E-19  -3.89819996661729E-01  -3.89819996659328E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40111309686497E-09   0.00000000000000E+00  -2.40111309686497E-09
      2.18327795926324E-18  -5.78751065370408E-03  -3.78054122335499E-03   0.00000000000000E+00   1.41446486823473E-12
      1.80254517732398E-22  -6.37139031904029E-09  -6.36997585417188E-09  -1.67965363498343E-18
      9.69852029731314E-09
      0.00000000000000E+00  -8.70623817411308E-12   0.00000000000000E+00  -1.94634226323452E-13   1.09296398729350E-22
      8.70645480191579E-09   8.70626016768957E-09  -4.93533543918578E-19  -3.94170998660586E-01  -3.94170998658247E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.33895339010419E-09   0.00000000000000E+00  -2.33895339010419E-09
      2.14731106896838E-18  -5.58933541679863E-03  -3.58320636950585E-03   0.00000000000000E+00   1.31751227958143E-12
      1.70349519487727E-22  -6.36862428986522E-09  -6.36730677758547E-09  -1.65377752504981E-18
      9.71927971137564E-09
      0.00000000000000E+00  -8.58491127626194E-12   0.00000000000000E+00  -2.75989092303297E-13   9.90358864380622E-23
      8.58521763248430E-09   8.58494164339210E-09  -4.80756818235529E-19  -3.99679540032448E-01  -3.99679540030229E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21876812130460E-09   0.00000000000000E+00  -2.21876812130460E-09
      2.10125074282955E-18  -5.35319599979866E-03  -3.34742330329172E-03   0.00000000000000E+00   1.20123977312277E-12
      1.54926409486939E-22  -6.36737476186070E-09  -6.36617352208742E-09  -1.62049392459402E-18
      9.74730492036001E-09
      0.00000000000000E+00  -8.35043166217113E-12   0.00000000000000E+00  -4.02081692554701E-13   8.42034886531426E-23
      8.35087347816322E-09   8.35047139647075E-09  -4.65639941828315E-19  -4.06199888437012E-01  -4.06199888435035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97633004983302E-09   0.00000000000000E+00  -1.97633004983302E-09
      2.04586368016087E-18  -5.08849766297661E-03  -3.08021369301732E-03   0.00000000000000E+00   1.00645694298694E-12
      1.31874810014267E-22  -6.37514780358089E-09  -6.37414134663777E-09  -1.58022373833256E-18
      9.78513895248892E-09
      0.00000000000000E+00  -7.82113044164415E-12   0.00000000000000E+00  -6.82631760314556E-13   6.41827702223081E-23
      7.82189200928318E-09   7.82120937752293E-09  -4.51870634357603E-19  -4.12204702340030E-01  -4.12204702338630E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39933528327812E-09   0.00000000000000E+00  -1.39933528327812E-09
      1.99292118409422E-18  -4.82879731469657E-03  -2.80547329921436E-03   0.00000000000000E+00   6.09877862622140E-13
      9.98669376080413E-23  -6.42248397210749E-09  -6.42187409424477E-09  -1.54105054973661E-18
      9.83513895248892E-09
      0.00000000000000E+00  -6.28567012500872E-12   0.00000000000000E+00  -1.51555057932419E-12   3.95264537154706E-23
      6.28720791676837E-09   6.28569236618908E-09  -4.58698619500076E-19  -4.09844743175646E-01  -4.09844743175862E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15075364454502E-10   0.00000000000000E+00   2.15075364454502E-10
      2.00367495231694E-18  -4.62784845759705E-03  -2.57966680611960E-03   0.00000000000000E+00  -3.00191291117517E-13
      5.94166196936916E-23  -6.50046753935253E-09  -6.50076773064359E-09  -1.54497633281687E-18
      9.88513895248892E-09
      0.00000000000000E+00  -3.62529546705550E-12   0.00000000000000E+00  -2.67486134907607E-12   1.45283549999618E-23
      3.62790969113678E-09   3.62523482978772E-09  -5.10677921920336E-19  -3.89258419212911E-01  -3.89258419215805E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89442348021914E-09   0.00000000000000E+00   2.89442348021914E-09
      2.14839612632790E-18  -4.65618753498821E-03  -2.60204372591290E-03   0.00000000000000E+00  -1.93575918436487E-12
      1.65266951411245E-23  -6.51772255082256E-09  -6.51965831000690E-09  -1.63771820440756E-18
      9.93513895248892E-09
      0.00000000000000E+00  -9.97525690810948E-13   0.00000000000000E+00  -2.63857667749571E-12  -1.48841668784948E-23
      1.00017840370150E-09   9.97539827023993E-10  -6.15690234953728E-19  -3.47183535517317E-01  -3.47183535522758E-01
      0.00000000000000E+00   0.00000000000000E+00   5.44024833406242E-09   0.00000000000000E+00   5.44024833406242E-09
      2.42040854303102E-18  -5.73399550755601E-03  -3.70565866491671E-03   0.00000000000000E+00  -4.80724391661310E-12
     -3.67447625479689E-23  -6.43298091716972E-09  -6.43778816108637E-09  -1.80471830807729E-18
      9.98513895248892E-09
      0.00000000000000E+00   5.01196730941474E-13   0.00000000000000E+00  -1.56637185456246E-12  -3.56682970818495E-23
     -4.99625482434712E-10  -5.01191854289311E-10  -7.53746270163950E-19  -2.89177149688784E-01  -2.89177149695357E-01
      0.00000000000000E+00   0.00000000000000E+00   6.57275361649274E-09   0.00000000000000E+00   6.57275361649274E-09
      2.74904622385566E-18  -1.18593586656790E-02  -9.94641118926715E-03   0.00000000000000E+00  -9.45512223353639E-12
     -7.24558283082524E-23  -6.06210663996985E-09  -6.07156176220345E-09  -1.99529995369171E-18
      1.00351389524889E-08
      0.00000000000000E+00   1.61380387747345E-12   0.00000000000000E+00  -1.22246072084210E-12  -4.17906828408547E-23
     -1.61256220084378E-09  -1.61378466156467E-09  -8.88454735116830E-19  -2.27241426010367E-01  -2.27241426016978E-01
      0.00000000000000E+00   0.00000000000000E+00   6.61118615565933E-09   0.00000000000000E+00   6.61118615565933E-09
      3.07960553163862E-18  -3.28796273843569E-02  -3.13051134465911E-02   0.00000000000000E+00  -1.74602252125086E-11
     -8.23615196194203E-23  -4.97994126888205E-09  -4.99740149409464E-09  -2.19115079652179E-18
      1.00601389524889E-08
      0.00000000000000E+00   1.97153912889677E-12   0.00000000000000E+00  -8.59633723973318E-13  -4.29056746791984E-23
     -1.97068388065122E-09  -1.97154351437524E-09  -9.51281057797991E-19  -1.96400663062680E-01  -1.96400663069007E-01
      0.00000000000000E+00   0.00000000000000E+00   6.32686568337112E-09   0.00000000000000E+00   6.32686568337112E-09
      3.23777717372290E-18  -4.74293871499642E-02  -4.60571672262520E-02   0.00000000000000E+00  -2.60493649141177E-11
     -8.66232295991394E-23  -4.32927280408172E-09  -4.35532216899593E-09  -2.28649611592491E-18
      1.00938889524889E-08
      0.00000000000000E+00   2.14824840328405E-12   0.00000000000000E+00  -4.30644734918239E-13  -4.40164438006052E-23
     -2.14777798891597E-09  -2.14820863365093E-09  -1.02905337115030E-18  -1.56462055819492E-01  -1.56462055825427E-01
      0.00000000000000E+00   0.00000000000000E+00   5.93419548393080E-09   0.00000000000000E+00   5.93419548393080E-09
      3.43805627130557E-18  -7.03296418387390E-02  -6.91367992894097E-02   0.00000000000000E+00  -3.49894199381453E-11
     -9.31212302598059E-23  -3.75099743034160E-09  -3.78598685027983E-09  -2.40900290015527E-18
      1.01052795774889E-08
      0.00000000000000E+00   2.12730780320073E-12   0.00000000000000E+00  -1.02559917399217E-13  -4.43921791344063E-23
     -2.12720972169405E-09  -2.12731228161149E-09  -1.05430571557397E-18  -1.43079986559087E-01  -1.43079986564789E-01
      0.00000000000000E+00   0.00000000000000E+00   5.70261005601092E-09   0.00000000000000E+00   5.70261005601092E-09
      3.50301256397482E-18  -7.83997675016551E-02  -7.72733020063531E-02   0.00000000000000E+00  -4.24335825752139E-11
     -9.53844691183349E-23  -3.53286419182426E-09  -3.57529777439957E-09  -2.44870684840084E-18
      1.01206569212389E-08
      0.00000000000000E+00   2.08101805564814E-12   0.00000000000000E+00  -5.00263080167954E-14  -4.48977220713247E-23
     -2.08094096268750E-09  -2.08099098899556E-09  -1.08673972019389E-18  -1.25572799479142E-01  -1.25572799484604E-01
      0.00000000000000E+00   0.00000000000000E+00   5.46204797398304E-09   0.00000000000000E+00   5.46204797398304E-09
      3.58700435324975E-18  -8.95317398648529E-02  -8.84664727736621E-02   0.00000000000000E+00  -4.68968771164436E-11
     -9.84334087585257E-23  -3.33416010787094E-09  -3.38105698498749E-09  -2.50026463305586E-18
      1.01414163353014E-08
      0.00000000000000E+00   1.98421370263141E-12   0.00000000000000E+00   2.40345289663741E-14  -4.55613720810113E-23
     -1.98427945875008E-09  -1.98425542422116E-09  -1.12753356754193E-18  -1.03035424145282E-01  -1.03035424150419E-01
      0.00000000000000E+00   0.00000000000000E+00   5.13666652188106E-09   0.00000000000000E+00   5.13666652188106E-09
      3.69363854047846E-18  -1.04719268798305E-01  -1.03726040417386E-01   0.00000000000000E+00  -5.22744376084915E-11
     -1.02526229900008E-22  -3.10013666005130E-09  -3.15241109765990E-09  -2.56610497293653E-18
      1.01694415442858E-08
      0.00000000000000E+00   1.79152344397002E-12   0.00000000000000E+00   1.31507268297007E-13  -4.63761608958753E-23
     -1.79172997384117E-09  -1.79159846657292E-09  -1.17637038920911E-18  -7.52729537317268E-02  -7.52729537363804E-02
      0.00000000000000E+00   0.00000000000000E+00   4.65356820056331E-09   0.00000000000000E+00   4.65356820056331E-09
      3.82405576182229E-18  -1.25233520861081E-01  -1.24331801458743E-01   0.00000000000000E+00  -5.83480709967899E-11
     -1.07985909512172E-22  -2.80362166299347E-09  -2.86196973399036E-09  -2.64768537261318E-18
      1.02072755764147E-08
      0.00000000000000E+00   1.38097746865237E-12   0.00000000000000E+00   3.56022519942011E-13  -4.72002507893294E-23
     -1.38128811238930E-09  -1.38093208986941E-09  -1.22628060772329E-18  -4.59757897844814E-02  -4.59757897882844E-02
      0.00000000000000E+00   0.00000000000000E+00   3.80302395477957E-09   0.00000000000000E+00   3.80302395477957E-09
      3.96793949231442E-18  -1.53014687012757E-01  -1.52251559867827E-01   0.00000000000000E+00  -6.19080652536316E-11
     -1.14914355765681E-22  -2.36018379965642E-09  -2.42209186491017E-09  -2.74165888459112E-18
      1.02572755764147E-08
      0.00000000000000E+00   7.60658113552737E-13   0.00000000000000E+00   5.10204102388306E-13  -4.77330826240405E-23
     -7.61165573533440E-10  -7.60655369431099E-10  -1.26113109833207E-18  -2.49049329856225E-02  -2.49049329881722E-02
      0.00000000000000E+00   0.00000000000000E+00   2.54972883732389E-09   0.00000000000000E+00   2.54972883732389E-09
      4.09542593418061E-18  -1.88532245977546E-01  -1.87968563813334E-01   0.00000000000000E+00  -5.66927856796467E-11
     -1.22367731522985E-22  -1.73238068221303E-09  -1.78907346789280E-09  -2.83429483584854E-18
      1.03072755764147E-08
      0.00000000000000E+00   3.64439917239466E-13   0.00000000000000E+00   3.50390169918014E-13  -4.79259519916958E-23
     -3.64769428433129E-10  -3.64419038263259E-10  -1.27622369092745E-18  -1.56506802734912E-02  -1.56506802751060E-02
      0.00000000000000E+00   0.00000000000000E+00   1.61477547093627E-09   0.00000000000000E+00   1.61477547093627E-09
      4.17616470772742E-18  -2.18551192884056E-01  -2.18157244033802E-01   0.00000000000000E+00  -4.59755657109164E-11
     -1.27841869688040E-22  -1.20438086696193E-09  -1.25035643267298E-09  -2.89994101679997E-18
      1.03572755764147E-08
      0.00000000000000E+00   2.06466969242520E-13   0.00000000000000E+00   1.41451114928739E-13  -4.79947518916566E-23
     -2.06632376207771E-10  -2.06490925092890E-10  -1.28348418971192E-18  -1.13054975796723E-02  -1.13054975807417E-02
      0.00000000000000E+00   0.00000000000000E+00   1.06946310945591E-09   0.00000000000000E+00   1.06946310945591E-09
      4.22963786320022E-18  -2.40364507292924E-01  -2.40092612637288E-01   0.00000000000000E+00  -3.32975716073731E-11
     -1.31548877121719E-22  -8.29674612755520E-10  -8.62972184363024E-10  -2.94615367348829E-18
      1.04072755764147E-08
      0.00000000000000E+00   1.46400511108798E-13   0.00000000000000E+00   5.45191355698326E-14  -4.80188754926081E-23
     -1.46464109783487E-10  -1.46409590647965E-10  -1.28779637124702E-18  -8.91267903277848E-03  -8.91267903352101E-03
      0.00000000000000E+00   0.00000000000000E+00   7.42526275772537E-10   0.00000000000000E+00   7.42526275772537E-10
      4.26676417698885E-18  -2.54783798798372E-01  -2.54595983810330E-01   0.00000000000000E+00  -2.18098261716852E-11
     -1.33880363011309E-22  -5.74306858952789E-10  -5.96116685124608E-10  -2.97896780574183E-18
      1.04572755764147E-08
      0.00000000000000E+00   1.18571555734917E-13   0.00000000000000E+00   2.67741213659349E-14  -4.80230127373623E-23
     -1.18613505338631E-10  -1.18586731217313E-10  -1.29076703417347E-18  -7.41617551568250E-03  -7.41617551624965E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67154235751935E-10   0.00000000000000E+00   5.67154235751935E-10
      4.29512188877644E-18  -2.64868458127298E-01  -2.64727132555858E-01   0.00000000000000E+00  -1.47128663459721E-11
     -1.35412289056663E-22  -4.33854638188496E-10  -4.48567504534604E-10  -3.00435485460297E-18
      1.04822755764147E-08
      0.00000000000000E+00   1.06999118846769E-13   0.00000000000000E+00   2.37436237357590E-14  -4.80207685886505E-23
     -1.07067517507424E-10  -1.07043773883736E-10  -1.29197565912658E-18  -6.84977373454550E-03  -6.84977373504439E-03
      0.00000000000000E+00   0.00000000000000E+00   4.98895936333310E-10   0.00000000000000E+00   4.98895936333310E-10
      4.30759428718478E-18  -2.69080524306142E-01  -2.68957068462656E-01   0.00000000000000E+00  -1.18742181858326E-11
     -1.36021543034971E-22  -3.79977944263605E-10  -3.91852162449574E-10  -3.01561862805819E-18
      1.05160255764147E-08
      0.00000000000000E+00   9.91004714469214E-14   0.00000000000000E+00   1.35688198255854E-14  -4.80146722234581E-23
     -9.90828028784377E-11  -9.90692340586601E-11  -1.29335950183749E-18  -6.23233549505011E-03  -6.23233549551495E-03
      0.00000000000000E+00   0.00000000000000E+00   4.64837799946901E-10   0.00000000000000E+00   4.64837799946901E-10
      4.32328256293298E-18  -2.74308960077309E-01  -2.74193722625205E-01   0.00000000000000E+00  -1.06838767123995E-11
     -1.36750610098838E-22  -3.55084689175675E-10  -3.65768565888211E-10  -3.02992306109550E-18
      1.05388068264147E-08
      0.00000000000000E+00   9.42327003749225E-14   0.00000000000000E+00   1.29255681297655E-14  -4.80091734097785E-23
     -9.42430878027928E-11  -9.42301622347111E-11  -1.29419291997309E-18  -5.87757147419416E-03  -5.87757147463329E-03
      0.00000000000000E+00   0.00000000000000E+00   4.39129385160633E-10   0.00000000000000E+00   4.39129385160633E-10
      4.33328647923868E-18  -2.77560662852847E-01  -2.77452000894225E-01   0.00000000000000E+00  -9.62299117618535E-12
     -1.37189838207008E-22  -3.35276231749594E-10  -3.44899222925917E-10  -3.03909355926558E-18
      1.05541841701647E-08
      0.00000000000000E+00   9.09262898354515E-14   0.00000000000000E+00   1.35543159928681E-14  -4.80047873356648E-23
     -9.09013505551598E-11  -9.08877962392150E-11  -1.29470842402600E-18  -5.66595566988131E-03  -5.66595567030706E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25746569380094E-10   0.00000000000000E+00   4.25746569380094E-10
      4.33983333058642E-18  -2.79675801472314E-01  -2.79570303043339E-01   0.00000000000000E+00  -9.14654458822486E-12
     -1.37469690992953E-22  -3.25712228552515E-10  -3.34858773140878E-10  -3.04512490656041E-18
      1.05749435842272E-08
      0.00000000000000E+00   8.69769661355278E-14   0.00000000000000E+00   1.24820803018231E-14  -4.79979071941467E-23
     -8.70201183131328E-11  -8.70076362328790E-11  -1.29533181823934E-18  -5.41853815364855E-03  -5.41853815406881E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20249924704251E-10   0.00000000000000E+00   4.20249924704251E-10
      4.34855747278309E-18  -2.82556967805784E-01  -2.82451978690146E-01   0.00000000000000E+00  -9.20558747209092E-12
     -1.37846518179750E-22  -3.24036700999062E-10  -3.33242288471290E-10  -3.05322565454374E-18
      1.06029687932116E-08
      0.00000000000000E+00   8.24765740123590E-14   0.00000000000000E+00   1.17401340176122E-14  -4.79871540694310E-23
     -8.24681123795154E-11  -8.24563722455458E-11  -1.29606082253852E-18  -5.13929234103306E-03  -5.13929234145397E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20909588711149E-10   0.00000000000000E+00   4.20909588711149E-10
      4.36035355197024E-18  -2.86626993699405E-01  -2.86520362726616E-01   0.00000000000000E+00  -9.71452710459230E-12
     -1.38377550513425E-22  -3.28738689360820E-10  -3.38453216465551E-10  -3.06429272943171E-18
      1.06408028253405E-08
      0.00000000000000E+00   7.52208397729644E-14   0.00000000000000E+00   1.39858659336623E-14  -4.79690561851863E-23
     -7.52384944542164E-11  -7.52245085883307E-11  -1.29680120914272E-18  -4.86005349287326E-03  -4.86005349332858E-03
      0.00000000000000E+00   0.00000000000000E+00   4.55313195065068E-10   0.00000000000000E+00   4.55313195065068E-10
      4.37757988602105E-18  -2.93429764552853E-01  -2.93310015074979E-01   0.00000000000000E+00  -1.26562792478372E-11
     -1.39295857441491E-22  -3.67432407228889E-10  -3.80088686476865E-10  -3.08077867687833E-18
      1.06908028253405E-08
      0.00000000000000E+00   6.52097634173440E-14   0.00000000000000E+00   1.56292211049313E-14  -4.79385704580052E-23
     -6.52119193613277E-11  -6.51962901402707E-11  -1.29733905943279E-18  -4.63750918936129E-03  -4.63750918989652E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35234899279449E-10   0.00000000000000E+00   5.35234899279449E-10
      4.40434163098502E-18  -3.05993976010879E-01  -3.05845885178791E-01   0.00000000000000E+00  -1.90563800695104E-11
     -1.41083300158108E-22  -4.50982229069514E-10  -4.70038609139165E-10  -3.10700257155224E-18
      1.07408028253405E-08
      0.00000000000000E+00   5.56579107477612E-14   0.00000000000000E+00   1.63160336282965E-14  -4.79019683336342E-23
     -5.56082199432754E-11  -5.55919039096951E-11  -1.29746301533591E-18  -4.59405794531967E-03  -4.59405794588861E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68934400747518E-10   0.00000000000000E+00   5.68934400747518E-10
      4.43278835102240E-18  -3.20429148049971E-01  -3.20267413122787E-01   0.00000000000000E+00  -2.28369267071478E-11
     -1.43171625226085E-22  -4.90505570130537E-10  -5.13342496837828E-10  -3.13532533568648E-18
      1.07908028253405E-08
      0.00000000000000E+00   2.77371106366731E-14   0.00000000000000E+00   3.84873831536581E-14  -4.78422709165564E-23
     -2.77555080824561E-11  -2.77170206993503E-11  -1.29626735815557E-18  -5.32645712868279E-03  -5.32645712920071E-03
      0.00000000000000E+00   0.00000000000000E+00   5.17923908541405E-10   0.00000000000000E+00   5.17923908541405E-10
      4.45868454644947E-18  -3.34793950765566E-01  -3.34639505595397E-01   0.00000000000000E+00  -2.21016415813920E-11
     -1.45142945703667E-22  -4.68105246260513E-10  -4.90206887842050E-10  -3.16241718829390E-18
      1.08408028253405E-08
      0.00000000000000E+00  -1.01580279351525E-13   0.00000000000000E+00   1.59062007969364E-13  -4.76672097444350E-23
      1.01444305901867E-10   1.01603367909789E-10  -1.28872720278525E-18  -9.82864994070373E-03  -9.82864994098830E-03
      0.00000000000000E+00   0.00000000000000E+00   2.84570945895295E-10   0.00000000000000E+00   2.84570945895295E-10
      4.47291309374423E-18  -3.48813452768684E-01  -3.48691786687562E-01   0.00000000000000E+00  -1.49126061522396E-11
     -1.46452764441539E-22  -3.71261707652718E-10  -3.86174313805105E-10  -3.18418589095898E-18
      1.08908028253405E-08
      0.00000000000000E+00  -5.67692320679723E-13   0.00000000000000E+00   5.59928124924785E-13  -4.70788533826237E-23
      5.67172248116375E-10   5.67732176241253E-10  -1.25831038284685E-18  -2.76497121949110E-02  -2.76497121944245E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.86482071290084E-10   0.00000000000000E+00  -4.86482071290084E-10
      4.44858899017973E-18  -3.63678416713223E-01  -3.63652827939118E-01   0.00000000000000E+00   8.68543464244814E-12
     -1.45733518657864E-22  -8.99355395934132E-11  -8.12501049511108E-11  -3.19027860733288E-18
      1.09158028253405E-08
      0.00000000000000E+00  -9.08068916770817E-13   0.00000000000000E+00   8.09849497881550E-13  -4.66408319379931E-23
      9.07185051468072E-10   9.07994900965907E-10  -1.23485503426559E-18  -4.11164586734647E-02  -4.11164586724333E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.03138343338088E-09   0.00000000000000E+00  -1.03138343338088E-09
      4.42280440434521E-18  -3.71406938983477E-01  -3.71445829181900E-01   0.00000000000000E+00   2.43511797191485E-11
     -1.44693401538742E-22   9.90373526957900E-11   1.23388532414794E-10  -3.18794937007962E-18
      1.09495528253405E-08
      0.00000000000000E+00  -1.17891904679581E-12   0.00000000000000E+00   5.52565143017868E-13  -4.59425898362403E-23
      1.17833542288202E-09   1.17888798802499E-09  -1.19507024207822E-18  -6.33813240067843E-02  -6.33813240053493E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.43505092215728E-09   0.00000000000000E+00  -1.43505092215728E-09
      4.37437143572240E-18  -3.81754364600748E-01  -3.81835091302400E-01   0.00000000000000E+00   3.44145614037442E-11
     -1.42653314677300E-22   2.21748372728731E-10   2.56162934132333E-10  -3.17930119364418E-18
      1.09723340753405E-08
      0.00000000000000E+00  -1.33569801320906E-12   0.00000000000000E+00   4.92903045372042E-13  -4.54491808693581E-23
      1.33516363527952E-09   1.33565653832485E-09  -1.16553952435868E-18  -7.94800689223682E-02  -7.94800689207368E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.63136043186480E-09   0.00000000000000E+00  -1.63136043186480E-09
      4.33720700588398E-18  -3.88521645671886E-01  -3.88614832852209E-01   0.00000000000000E+00   3.78207134952222E-11
     -1.41095919200708E-22   2.57883180044899E-10   2.95703893539980E-10  -3.17166748152530E-18
      1.09877114190905E-08
      0.00000000000000E+00  -1.43617615571410E-12   0.00000000000000E+00   4.70298649477709E-13  -4.51073137491692E-23
      1.43567568079393E-09   1.43614597944336E-09  -1.14469203415757E-18  -9.06341597047207E-02  -9.06341597029885E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73219273963435E-09   0.00000000000000E+00  -1.73219273963435E-09
      4.31057048268537E-18  -3.92949820382162E-01  -3.93043117608469E-01   0.00000000000000E+00   3.89393421986663E-11
     -1.39988258926724E-22   2.57107417992520E-10   2.96046760191046E-10  -3.16587844852780E-18
      1.10084708331530E-08
      0.00000000000000E+00  -1.55878887988614E-12   0.00000000000000E+00   4.32077583303669E-13  -4.46064013742624E-23
      1.55834393256417E-09   1.55877601014743E-09  -1.11573429595944E-18  -1.05842995864933E-01  -1.05842995863124E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80843009483843E-09   0.00000000000000E+00  -1.80843009483843E-09
      4.27302853354353E-18  -3.98603527336619E-01  -3.98682211800763E-01   0.00000000000000E+00   3.94927729166379E-11
     -1.38430754444944E-22   2.10161311774518E-10   2.49654084691017E-10  -3.15729423758408E-18
      1.10364960421374E-08
      0.00000000000000E+00  -1.78840072290496E-12   0.00000000000000E+00   5.33569787391059E-13  -4.36624209751233E-23
      1.78790725085023E-09   1.78844082063758E-09  -1.07563095706018E-18  -1.26385487727632E-01  -1.26385487725737E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89474884490860E-09   0.00000000000000E+00  -1.89474884490860E-09
      4.21992780119206E-18  -4.05419290536764E-01  -4.05452820431118E-01   0.00000000000000E+00   3.99829115411667E-11
     -1.36216612027757E-22   6.63251127299815E-11   1.06308024271012E-10  -3.14429684413188E-18
      1.10743300742663E-08
      0.00000000000000E+00  -2.38438122264460E-12   0.00000000000000E+00   8.92278922958225E-13  -4.06540741294608E-23
      2.38350275770266E-09   2.38439503662557E-09  -1.01937561786396E-18  -1.54224396825447E-01  -1.54224396823385E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.06165401972777E-09   0.00000000000000E+00  -2.06165401972777E-09
      4.14192711677099E-18  -4.12193603887641E-01  -4.12091978533355E-01   0.00000000000000E+00   4.22760885837071E-11
     -1.32862343935353E-22  -3.65017105481363E-10  -3.22741016897788E-10  -3.12255149890704E-18
      1.11243300742663E-08
      0.00000000000000E+00  -4.08295779256060E-12   0.00000000000000E+00   1.76933783163993E-12  -2.71894271493954E-23
      4.08122495677645E-09   4.08299429460806E-09  -9.44303141652973E-19  -1.89679183917179E-01  -1.89679183914841E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.33836576907002E-09   0.00000000000000E+00  -2.33836576907002E-09
      4.02500882831749E-18  -4.12116221885821E-01  -4.11566670683897E-01   0.00000000000000E+00   4.81182403495787E-11
     -1.27322650722078E-22  -1.79274676588751E-09  -1.74462852553806E-09  -3.08070568666452E-18
      1.11743300742663E-08
      0.00000000000000E+00  -7.04109308854062E-12   0.00000000000000E+00   2.98240819001873E-12   5.43446213948607E-24
      7.03815481144550E-09   7.04113721963553E-09  -8.78391251920336E-19  -2.19455437646064E-01  -2.19455437643492E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57179847007555E-09   0.00000000000000E+00  -2.57179847007555E-09
      3.89641890481372E-18  -3.95001614141215E-01  -3.93593684081447E-01   0.00000000000000E+00   5.39466582388422E-11
     -1.20336976188243E-22  -4.52328540779870E-09  -4.46933874955997E-09  -3.01802765289338E-18
      1.12243300742663E-08
      0.00000000000000E+00  -1.02858758093453E-11   0.00000000000000E+00   3.24039722555831E-12   4.49287707795087E-23
      1.02826738881750E-08   1.02859142854006E-08  -8.29832905235560E-19  -2.40990872303201E-01  -2.40990872300462E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73852530041379E-09   0.00000000000000E+00  -2.73852530041379E-09
      3.75949263979302E-18  -3.56364932869978E-01  -3.53987259592787E-01   0.00000000000000E+00   5.64899169043590E-11
     -1.12335475038007E-22  -7.60387890189108E-09  -7.54738898498683E-09  -2.92965973455747E-18
      1.12743300742663E-08
      0.00000000000000E+00  -1.23606484228634E-11   0.00000000000000E+00   2.07006165099980E-12   7.18661169925003E-23
      1.23585902894777E-08   1.23606603511288E-08  -7.98601581221145E-19  -2.55201438604695E-01  -2.55201438601836E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85913905907047E-09   0.00000000000000E+00  -2.85913905907047E-09
      3.61653568683950E-18  -3.00186442535869E-01  -2.97193063836810E-01   0.00000000000000E+00   5.16551929391184E-11
     -1.04413637930328E-22  -9.55317648499729E-09  -9.50152129205828E-09  -2.81793410561836E-18
      1.13243300742663E-08
      0.00000000000000E+00  -1.31815566840242E-11   0.00000000000000E+00   8.24050293958139E-13   8.26293972717492E-23
      1.31807424642563E-08   1.31815665145503E-08  -7.78030831396888E-19  -2.65184086471668E-01  -2.65184086468765E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90314102000148E-09   0.00000000000000E+00  -2.90314102000148E-09
      3.47137863583943E-18  -2.38092672467974E-01  -2.34854459687974E-01   0.00000000000000E+00   3.97313077076660E-11
     -9.62711872861836E-23  -1.03181568022565E-08  -1.02784254945489E-08  -2.69334780444254E-18
      1.13493300742663E-08
      0.00000000000000E+00  -1.32621963632924E-11   0.00000000000000E+00   1.69750659633964E-13   8.38005849609739E-23
      1.32619402632486E-08   1.32621100139083E-08  -7.69863132127478E-19  -2.69363125834971E-01  -2.69363125832054E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91678496382641E-09   0.00000000000000E+00  -2.91678496382641E-09
      3.39845901174377E-18  -2.06995451432359E-01  -2.03736129305952E-01   0.00000000000000E+00   3.13991966214696E-11
     -9.23268321250801E-23  -1.03767242467032E-08  -1.03453250500818E-08  -2.62859587961629E-18
      1.13830800742663E-08
      0.00000000000000E+00  -1.32779018133549E-11   0.00000000000000E+00   3.15419373532890E-14   8.27145394306642E-23
      1.32778336468626E-08   1.32778651888000E-08  -7.60107028824098E-19  -2.74563831017987E-01  -2.74563831015097E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89005327396466E-09   0.00000000000000E+00  -2.89005327396466E-09
      3.30091971374746E-18  -1.66664304911697E-01  -1.63391563372396E-01   0.00000000000000E+00   2.53320413042000E-11
     -8.81970009902370E-23  -1.04131439561395E-08  -1.03878119148354E-08  -2.54081268492336E-18
      1.14058613242663E-08
      0.00000000000000E+00  -1.31721885208291E-11   0.00000000000000E+00  -2.21039241421737E-13   8.07534490861089E-23
      1.31724316020653E-08   1.31722105628240E-08  -7.54279633422543E-19  -2.77803678189297E-01  -2.77803678186419E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87805475322445E-09   0.00000000000000E+00  -2.87805475322445E-09
      3.23535402890057E-18  -1.40138085771390E-01  -1.36894832203485E-01   0.00000000000000E+00   2.13688264064294E-11
     -8.58613260848116E-23  -1.03155246360058E-08  -1.02941558095995E-08  -2.48107439547802E-18
      1.14212386680163E-08
      0.00000000000000E+00  -1.30676692098869E-11   0.00000000000000E+00  -3.28129154292736E-13   7.91428009988204E-23
      1.30680414844081E-08   1.30677133552539E-08  -7.50574561392941E-19  -2.79913972879932E-01  -2.79913972877066E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86667715294034E-09   0.00000000000000E+00  -2.86667715294034E-09
      3.19127214889953E-18  -1.22697430917903E-01  -1.19483504155003E-01   0.00000000000000E+00   1.90093581689687E-11
     -8.42085969556116E-23  -1.02200455604824E-08  -1.02010362023135E-08  -2.44069758750659E-18
      1.14419980820788E-08
      0.00000000000000E+00  -1.29322900672430E-11   0.00000000000000E+00  -3.14981246796706E-13   7.72492796750725E-23
      1.29325598739009E-08   1.29322448926541E-08  -7.45541520597179E-19  -2.82793627175877E-01  -2.82793627173038E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83913396778567E-09   0.00000000000000E+00  -2.83913396778567E-09
      3.13233339128336E-18  -1.00301327189063E-01  -9.71213901455955E-02   0.00000000000000E+00   1.67202589213999E-11
     -8.14627054642053E-23  -1.01098311837898E-08  -1.00931109248685E-08  -2.38679187068618E-18
      1.14700232910631E-08
      0.00000000000000E+00  -1.26653892609179E-11   0.00000000000000E+00  -4.61779091837039E-13   7.53090449956120E-23
      1.26658502890920E-08   1.26653885100002E-08  -7.38275143858561E-19  -2.86879106075771E-01  -2.86879106072979E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79220915955156E-09   0.00000000000000E+00  -2.79220915955156E-09
      3.05408114605884E-18  -7.28686165256075E-02  -6.97579563450434E-02   0.00000000000000E+00   1.38900463068042E-11
     -7.37484715284689E-23  -9.88706939675543E-09  -9.87317935044869E-09  -2.31580600220028E-18
      1.15078573231921E-08
      0.00000000000000E+00  -1.19669100344547E-11   0.00000000000000E+00  -8.99028023797618E-13   7.63344736773601E-23
      1.19678554791975E-08   1.19669564511738E-08  -7.24773043279239E-19  -2.93758781809739E-01  -2.93758781807060E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67978445773407E-09   0.00000000000000E+00  -2.67978445773407E-09
      2.95269409478639E-18  -4.43520447691927E-02  -4.14259986888797E-02   0.00000000000000E+00   1.02642564806426E-11
     -4.26767398757956E-23  -9.29743624992035E-09  -9.28717199343975E-09  -2.22792105150715E-18
      1.15578573231921E-08
      0.00000000000000E+00  -1.07082697557628E-11   0.00000000000000E+00  -1.22428776506343E-12   8.87260221082344E-23
      1.07095241149519E-08   1.07082998271869E-08  -6.96918873043898E-19  -3.06415460487125E-01  -3.06415460484661E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46345813493825E-09   0.00000000000000E+00  -2.46345813493825E-09
      2.82952118803948E-18  -2.41852980689759E-02  -2.15876412051439E-02   0.00000000000000E+00   6.42704706176795E-12
      3.13061408295301E-23  -8.25126873931048E-09  -8.24484169224868E-09  -2.13260231499558E-18
      1.16078573231921E-08
      0.00000000000000E+00  -9.70358017544962E-12   0.00000000000000E+00  -9.72157576511434E-13   1.06779853191071E-22
      9.70450640391554E-09   9.70353424633913E-09  -6.63662650186082E-19  -3.20867587095640E-01  -3.20867587093363E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27774123178442E-09   0.00000000000000E+00  -2.27774123178442E-09
      2.71563412645025E-18  -1.53358256614893E-02  -1.29962159940424E-02   0.00000000000000E+00   3.97297067035338E-12
      9.97006671008855E-23  -7.42976598522521E-09  -7.42579301455475E-09  -2.05197147626417E-18
      1.16578573231921E-08
      0.00000000000000E+00  -9.09676199671949E-12   0.00000000000000E+00  -5.80928099470454E-13   1.21679198875126E-22
      9.09733661473648E-09   9.09675568663714E-09  -6.30351055762817E-19  -3.35218842896320E-01  -3.35218842894161E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15888804810342E-09   0.00000000000000E+00  -2.15888804810342E-09
      2.60768972404508E-18  -1.11430228484612E-02  -8.95713791852112E-03   0.00000000000000E+00   2.69280278316362E-12
      1.48841057222378E-22  -6.94056044131700E-09  -6.93786763853368E-09  -1.97733866828226E-18
      1.17078573231921E-08
      0.00000000000000E+00  -8.76850890593979E-12   0.00000000000000E+00  -3.07717523506264E-13   1.29683510418213E-22
      8.76878635463435E-09   8.76847863711097E-09  -5.97901744799790E-19  -3.49238046093402E-01  -3.49238046091276E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12585745620191E-09   0.00000000000000E+00  -2.12585745620191E-09
      2.50139685123499E-18  -8.81522827781104E-03  -6.72236286763565E-03   0.00000000000000E+00   2.08140130018300E-12
      1.78712386854325E-22  -6.64470258220948E-09  -6.64262118090912E-09  -1.90349510643520E-18
      1.17578573231921E-08
      0.00000000000000E+00  -8.77457065859548E-12   0.00000000000000E+00   2.18803690349744E-14   1.31725847673098E-22
      8.77453102136240E-09   8.77455290173157E-09  -5.63423055864037E-19  -3.64131782724646E-01  -3.64131782722360E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28663269131464E-09   0.00000000000000E+00  -2.28663269131464E-09
      2.38706521666925E-18  -7.35175908416728E-03  -5.30763264410317E-03   0.00000000000000E+00   1.84160231640829E-12
      1.93716316518281E-22  -6.48976181273350E-09  -6.48792021041690E-09  -1.82364216080522E-18
      1.17828573231921E-08
      0.00000000000000E+00  -8.83886197464075E-12   0.00000000000000E+00   1.42599669652704E-13   1.29803020429647E-22
      8.83872075847468E-09   8.83886335814446E-09  -5.45463471562997E-19  -3.71863166614242E-01  -3.71863166611831E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41154851008068E-09   0.00000000000000E+00  -2.41154851008068E-09
      2.32677650391724E-18  -6.79558432431240E-03  -4.77055161633031E-03   0.00000000000000E+00   1.75078577134684E-12
      1.95004719953415E-22  -6.42906563383535E-09  -6.42731484806381E-09  -1.78131303235424E-18
      1.18166073231921E-08
      0.00000000000000E+00  -8.83739245884543E-12   0.00000000000000E+00   1.31865800705580E-14   1.22775222441331E-22
      8.83735661693668E-09   8.83736980351688E-09  -5.21466231702789E-19  -3.82196373441458E-01  -3.82196373439021E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43685948254405E-09   0.00000000000000E+00  -2.43685948254405E-09
      2.24453249638138E-18  -6.18869087209101E-03  -4.17210204827216E-03   0.00000000000000E+00   1.57765079499006E-12
      1.88321045791619E-22  -6.40208797176804E-09  -6.40051032097286E-09  -1.72306626467859E-18
      1.18393885731921E-08
      0.00000000000000E+00  -8.78540833758597E-12   0.00000000000000E+00  -9.81807244201167E-14   1.15058561755495E-22
      8.78547534694642E-09   8.78537716622211E-09  -5.05779997292246E-19  -3.88948141970368E-01  -3.88948141967961E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40640448306702E-09   0.00000000000000E+00  -2.40640448306702E-09
      2.18971159425151E-18  -5.83999383281015E-03  -3.83018994286800E-03   0.00000000000000E+00   1.46873363575679E-12
      1.78173025123928E-22  -6.38044141679097E-09  -6.37897268315504E-09  -1.68393159695926E-18
      1.18547659169421E-08
      0.00000000000000E+00  -8.72901566894055E-12   0.00000000000000E+00  -1.67111871728739E-13   1.08629806201108E-22
      8.72920494159231E-09   8.72903782972069E-09  -4.95519398035726E-19  -3.93363323489360E-01  -3.93363323486999E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36089947324349E-09   0.00000000000000E+00  -2.36089947324349E-09
      2.15340723149225E-18  -5.63198694911467E-03  -3.62559603087426E-03   0.00000000000000E+00   1.37229194783704E-12
      1.68989691112271E-22  -6.36951064842522E-09  -6.36813835647721E-09  -1.65788783345652E-18
      1.18755253310046E-08
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00  -2.43359596377323E-13   9.88705525754003E-23
      8.62156631380606E-09   8.62132295420978E-09  -4.82429259986196E-19  -3.98994473343018E-01  -3.98994473340762E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25570800335546E-09   0.00000000000000E+00  -2.25570800335546E-09
      2.10658005504649E-18  -5.38878599234755E-03  -3.38318939749793E-03   0.00000000000000E+00   1.23841214332865E-12
      1.54445633893220E-22  -6.36685336299780E-09  -6.36561495085432E-09  -1.62415079506030E-18
      1.19035505399889E-08
      0.00000000000000E+00  -8.41031443083043E-12   0.00000000000000E+00  -3.60350317550288E-13   8.45654047948221E-23
      8.41068983554565E-09   8.41032948522819E-09  -4.66684150783918E-19  -4.05766794637863E-01  -4.05766794635823E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04008555346411E-09   0.00000000000000E+00  -2.04008555346411E-09
      2.04940623106466E-18  -5.11463099505258E-03  -3.10757507290611E-03   0.00000000000000E+00   1.05709363474815E-12
      1.32330942179609E-22  -6.37130102539895E-09  -6.37024393176407E-09  -1.58272208028074E-18
      1.19413845721178E-08
      0.00000000000000E+00  -7.94254918423250E-12   0.00000000000000E+00  -6.01684508217223E-13   6.50363037985992E-23
      7.94322606975362E-09   7.94262438524547E-09  -4.51285030808333E-19  -4.12432809278839E-01  -4.12432809277307E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53245907852678E-09   0.00000000000000E+00  -1.53245907852678E-09
      1.99142712505144E-18  -4.84153757731401E-03  -2.82190269398889E-03   0.00000000000000E+00   6.97649593755169E-13
      1.01212227979500E-22  -6.41086295631253E-09  -6.41016530671868E-09  -1.54014209424311E-18
      1.19913845721178E-08
      0.00000000000000E+00  -6.57525658142405E-12   0.00000000000000E+00  -1.34812280164377E-12   4.09935870355347E-23
      6.57659753823786E-09   6.57524941543625E-09  -4.53266641848459E-19  -4.12031714996623E-01  -4.12031714996540E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.31984973502824E-11   0.00000000000000E+00  -8.31984973502824E-11
      1.98726720018393E-18  -4.62404906340520E-03  -2.57861378114908E-03   0.00000000000000E+00  -1.31178812101301E-13
      6.18926486617737E-23  -6.49191973927394E-09  -6.49205091808597E-09  -1.53400055833547E-18
      1.20413845721178E-08
      0.00000000000000E+00  -4.03106551603835E-12   0.00000000000000E+00  -2.54201495490028E-12   1.72010694872918E-23
      4.03361702984800E-09   4.03107501489311E-09  -4.97816516812268E-19  -3.94412557353953E-01  -3.94412557356445E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49182768804720E-09   0.00000000000000E+00   2.49182768804720E-09
      2.11185858458629E-18  -4.59169618540204E-03  -2.53653471718836E-03   0.00000000000000E+00  -1.64453053180983E-12
      2.14252893800748E-23  -6.52125817240852E-09  -6.52290270294031E-09  -1.61404206777402E-18
      1.20913845721178E-08
      0.00000000000000E+00  -1.29445972620288E-12   0.00000000000000E+00  -2.74075116006530E-12  -1.10736882555199E-23
      1.29714743316664E-09   1.29440668200657E-09  -5.95832859208301E-19  -3.55261079163057E-01  -3.55261079168223E-01
      0.00000000000000E+00   0.00000000000000E+00   5.16598971167305E-09   0.00000000000000E+00   5.16598971167305E-09
      2.37015807016994E-18  -5.37853191154157E-03  -3.34307147945198E-03   0.00000000000000E+00  -4.28888143964399E-12
     -2.96407493726798E-23  -6.45610751223995E-09  -6.46039639367963E-09  -1.77432521096164E-18
      1.21413845721178E-08
      0.00000000000000E+00   3.52316411928073E-13   0.00000000000000E+00  -1.70600536031164E-12  -3.38379662516011E-23
     -3.50595884700952E-10  -3.52301890061297E-10  -7.31759322867356E-19  -2.98778780127085E-01  -2.98778780133605E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51978281394289E-09   0.00000000000000E+00   6.51978281394289E-09
      2.69614721086709E-18  -1.01464411948097E-02  -8.20327214872989E-03   0.00000000000000E+00  -8.59764755956827E-12
     -6.94786825615094E-23  -6.15888327632191E-09  -6.16748092388155E-09  -1.96438788799973E-18
      1.21913845721178E-08
      0.00000000000000E+00   1.46345404266473E-12   0.00000000000000E+00  -1.21620586706876E-12  -4.13455004504743E-23
     -1.46221216654493E-09  -1.46342837241204E-09  -8.68841330395710E-19  -2.36673438997503E-01  -2.36673439004159E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65596679953669E-09   0.00000000000000E+00   6.65596679953669E-09
      3.02894555084392E-18  -2.85728912702852E-02  -2.69368963161749E-02   0.00000000000000E+00  -1.59476056401968E-11
     -8.11893236543572E-23  -5.17659082148437E-09  -5.19253842712465E-09  -2.16010422044821E-18
      1.22163845721178E-08
      0.00000000000000E+00   1.88667459171701E-12   0.00000000000000E+00  -9.83535480431325E-13  -4.26292538007564E-23
     -1.88573567195203E-09  -1.88671920743250E-09  -9.32929416464125E-19  -2.05603505516020E-01  -2.05603505522425E-01
      0.00000000000000E+00   0.00000000000000E+00   6.40525796438351E-09   0.00000000000000E+00   6.40525796438351E-09
      3.18907699995351E-18  -4.22577299726893E-02  -4.08340864367288E-02   0.00000000000000E+00  -2.39078162458102E-11
     -8.52167510251912E-23  -4.49463094070518E-09  -4.51853875695108E-09  -2.25614758348938E-18
      1.22501345721178E-08
      0.00000000000000E+00   2.13621674270986E-12   0.00000000000000E+00  -5.31853768193938E-13  -4.37716102437816E-23
     -2.13567275290353E-09  -2.13620460667176E-09  -1.01222719031794E-18  -1.65320709543643E-01  -1.65320709549683E-01
      0.00000000000000E+00   0.00000000000000E+00   6.03930007343103E-09   0.00000000000000E+00   6.03930007343103E-09
      3.39290337743181E-18  -6.46572937170300E-02  -6.34275545897779E-02   0.00000000000000E+00  -3.26226607870694E-11
     -9.16035403258954E-23  -3.87047280597209E-09  -3.90309546675925E-09  -2.38067618711387E-18
      1.22729158221178E-08
      0.00000000000000E+00   2.12776702688677E-12   0.00000000000000E+00  -1.70299232510304E-13  -4.45166169653790E-23
     -2.12761836327814E-09  -2.12778866251069E-09  -1.06231900106412E-18  -1.38838567752997E-01  -1.38838567758675E-01
      0.00000000000000E+00   0.00000000000000E+00   5.67838969289318E-09   0.00000000000000E+00   5.67838969289318E-09
      3.52226419262303E-18  -8.08000441431727E-02  -7.96813612644068E-02   0.00000000000000E+00  -4.16266879375597E-11
     -9.60941540544950E-23  -3.50897434244483E-09  -3.55060103038249E-09  -2.45994519155891E-18
      1.22882931658678E-08
      0.00000000000000E+00   2.06935377402279E-12   0.00000000000000E+00  -1.38287959932331E-14  -4.50218147567778E-23
     -2.06933511432890E-09  -2.06934894312494E-09  -1.09440046104612E-18  -1.21436054184528E-01  -1.21436054189938E-01
      0.00000000000000E+00   0.00000000000000E+00   5.40980007495598E-09   0.00000000000000E+00   5.40980007495598E-09
      3.60545254799440E-18  -9.19691986593314E-02  -9.09167249602142E-02   0.00000000000000E+00  -4.80038819384402E-11
     -9.91443676226065E-23  -3.29244724989249E-09  -3.34045113183103E-09  -2.51105208694828E-18
      1.23090525799303E-08
      0.00000000000000E+00   1.96272203412485E-12   0.00000000000000E+00   4.60925173583805E-14  -4.56802980847709E-23
     -1.96274446037555E-09  -1.96269836785824E-09  -1.13462267714325E-18  -9.91090849974260E-02  -9.91090850025023E-02
      0.00000000000000E+00   0.00000000000000E+00   5.07630589543763E-09   0.00000000000000E+00   5.07630589543763E-09
      3.71083368398570E-18  -1.07183887542614E-01  -1.06202884754290E-01   0.00000000000000E+00  -5.33523943612099E-11
     -1.03237168577481E-22  -3.06025513321806E-09  -3.11360752757938E-09  -2.57621100684245E-18
      1.23370777889147E-08
      0.00000000000000E+00   1.75653059909395E-12   0.00000000000000E+00   1.56040490710347E-13  -4.64782581916404E-23
     -1.75663354174565E-09  -1.75647750125498E-09  -1.18240681482312E-18  -7.18289605986661E-02  -7.18289606032436E-02
      0.00000000000000E+00   0.00000000000000E+00   4.57749675321703E-09   0.00000000000000E+00   4.57749675321703E-09
      3.83911898711990E-18  -1.27730623924818E-01  -1.26841806618085E-01   0.00000000000000E+00  -5.91470367631154E-11
     -1.08685784708589E-22  -2.76187221519886E-09  -2.82101925196208E-09  -2.65671217229679E-18
      1.23749118210436E-08
      0.00000000000000E+00   1.32642169475110E-12   0.00000000000000E+00   3.86676973132095E-13  -4.72644399938588E-23
     -1.32680880394987E-09  -1.32642212697679E-09  -1.23023226708941E-18  -4.36596958029043E-02  -4.36596958066020E-02
      0.00000000000000E+00   0.00000000000000E+00   3.69776070178302E-09   0.00000000000000E+00   3.69776070178302E-09
      3.97902018431617E-18  -1.55584559202008E-01  -1.54837422759139E-01   0.00000000000000E+00  -6.19594176099053E-11
     -1.15540587520732E-22  -2.30937915719616E-09  -2.37133857480618E-09  -2.74878791722676E-18
      1.24249118210436E-08
      0.00000000000000E+00   7.16572639693124E-13   0.00000000000000E+00   5.06316022988785E-13  -4.77582116333467E-23
     -7.17080659731208E-10  -7.16574343708267E-10  -1.26287581708463E-18  -2.38796075075261E-02  -2.38796075099847E-02
      0.00000000000000E+00   0.00000000000000E+00   2.45864540517627E-09   0.00000000000000E+00   2.45864540517627E-09
      4.10195245457499E-18  -1.90920498639816E-01  -1.90371625447060E-01   0.00000000000000E+00  -5.60155965090156E-11
     -1.22841959931091E-22  -1.68605546495885E-09  -1.74207106146799E-09  -2.83907663749035E-18
      1.24749118210436E-08
      0.00000000000000E+00   3.45611746111923E-13   0.00000000000000E+00   3.28581279959958E-13  -4.79357644492027E-23
     -3.45927707205039E-10  -3.45599125925127E-10  -1.27702789369514E-18  -1.52007586125984E-02  -1.52007586141614E-02
      0.00000000000000E+00   0.00000000000000E+00   1.56295361047081E-09   0.00000000000000E+00   1.56295361047081E-09
      4.18010013509853E-18  -2.20417808269597E-01  -2.20034257385000E-01   0.00000000000000E+00  -4.50830207537293E-11
     -1.28177295723561E-22  -1.17227146379184E-09  -1.21735448454570E-09  -2.90307224140338E-18
      1.25249118210436E-08
      0.00000000000000E+00   1.99762303426371E-13   0.00000000000000E+00   1.30670897877944E-13  -4.79993510292818E-23
     -1.99863397914301E-10  -1.99732727016471E-10  -1.28395077387100E-18  -1.10725359174225E-02  -1.10725359184623E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03978772220368E-09   0.00000000000000E+00   1.03978772220368E-09
      4.23208952120871E-18  -2.41653520025302E-01  -2.41388845994565E-01   0.00000000000000E+00  -3.24080449640260E-11
     -1.31771152177565E-22  -8.07646950223071E-10  -8.40054995187229E-10  -2.94813874733771E-18
      1.25749118210436E-08
      0.00000000000000E+00   1.43645168992572E-13   0.00000000000000E+00   5.10268534015532E-14  -4.80213465622442E-23
     -1.43685710036097E-10  -1.43634683182744E-10  -1.28812399772346E-18  -8.77255288997347E-03  -8.77255289069868E-03
      0.00000000000000E+00   0.00000000000000E+00   7.25203027376308E-10   0.00000000000000E+00   7.25203027376308E-10
      4.26834967257753E-18  -2.55648456212082E-01  -2.55465225074993E-01   0.00000000000000E+00  -2.11291137405764E-11
     -1.34024511303944E-22  -5.60439230452857E-10  -5.81568344193568E-10  -2.98022567485406E-18
      1.26249118210436E-08
      0.00000000000000E+00   1.17102039939597E-13   0.00000000000000E+00   2.56963229246443E-14  -4.80243656122613E-23
     -1.17149177433629E-10  -1.17123481110753E-10  -1.29102109292969E-18  -7.32317738360807E-03  -7.32317738416692E-03
      0.00000000000000E+00   0.00000000000000E+00   5.58848315316570E-10   0.00000000000000E+00   5.58848315316570E-10
      4.29629208834336E-18  -2.65535665545044E-01  -2.65396495954139E-01   0.00000000000000E+00  -1.43779952756544E-11
     -1.35518743078142E-22  -4.27346838930020E-10  -4.41724834205810E-10  -3.00527099541366E-18
      1.26499118210436E-08
      0.00000000000000E+00   1.06080671474693E-13   0.00000000000000E+00   2.27961575294277E-14  -4.80217994634304E-23
     -1.06147004610806E-10  -1.06124208453324E-10  -1.29220649550200E-18  -6.77118772856742E-03  -6.77118772906107E-03
      0.00000000000000E+00   0.00000000000000E+00   4.93643638075114E-10   0.00000000000000E+00   4.93643638075114E-10
      4.30863317929523E-18  -2.69684393010536E-01  -2.69562302326245E-01   0.00000000000000E+00  -1.16575853993696E-11
     -1.36115901465954E-22  -3.75861844222270E-10  -3.87519429621775E-10  -3.01642668379323E-18
      1.26836618210436E-08
      0.00000000000000E+00   9.83657135492612E-14   0.00000000000000E+00   1.34004897706457E-14  -4.80153391451682E-23
     -9.83437864736260E-11  -9.83303859839034E-11  -1.29356506569095E-18  -6.16882854297565E-03  -6.16882854343690E-03
      0.00000000000000E+00   0.00000000000000E+00   4.61243668634378E-10   0.00000000000000E+00   4.61243668634378E-10
      4.32420015311165E-18  -2.74858457505477E-01  -2.74744119699686E-01   0.00000000000000E+00  -1.05422891854090E-11
     -1.36834178937745E-22  -3.52370993464893E-10  -3.62913282650439E-10  -3.03063508742069E-18
      1.27064430710436E-08
      0.00000000000000E+00   9.35897872144698E-14   0.00000000000000E+00   1.28423926697330E-14  -4.80096228903462E-23
     -9.35819602218203E-11  -9.35691178291986E-11  -1.29438319891404E-18  -5.82285726028257E-03  -5.82285726071909E-03
      0.00000000000000E+00   0.00000000000000E+00   4.36518689901658E-10   0.00000000000000E+00   4.36518689901658E-10
      4.33414459451597E-18  -2.78087000266059E-01  -2.77978952608388E-01   0.00000000000000E+00  -9.52935593095081E-12
     -1.37268471423894E-22  -3.33420216141377E-10  -3.42949572072465E-10  -3.03976139560193E-18
      1.27218204147936E-08
      0.00000000000000E+00   9.02833766749988E-14   0.00000000000000E+00   1.34531759111917E-14  -4.80051050248603E-23
     -9.02957856928112E-11  -9.02823325169481E-11  -1.29488924451519E-18  -5.61650398702448E-03  -5.61650398744831E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23828309697623E-10   0.00000000000000E+00   4.23828309697623E-10
      4.34066194812517E-18  -2.80193012953313E-01  -2.80087928165300E-01   0.00000000000000E+00  -9.08908587752734E-12
     -1.37546137212204E-22  -3.24456891302967E-10  -3.33545977180632E-10  -3.04577270360998E-18
      1.27425798288561E-08
      0.00000000000000E+00   8.64258977122827E-14   0.00000000000000E+00   1.24278560961213E-14  -4.79980635474277E-23
     -8.64666566358793E-11  -8.64542287798311E-11  -1.29550096605256E-18  -5.37527773661257E-03  -5.37527773703173E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19152613723383E-10   0.00000000000000E+00   4.19152613723383E-10
      4.34936331078883E-18  -2.83072704657838E-01  -2.82967886920375E-01   0.00000000000000E+00  -9.19417810427125E-12
     -1.37921911814466E-22  -3.23504206839147E-10  -3.32698384943556E-10  -3.05386234473627E-18
      1.27706050378405E-08
      0.00000000000000E+00   8.19255055891139E-14   0.00000000000000E+00   1.18448452863264E-14  -4.79870768756841E-23
     -8.18972122020284E-11  -8.18853673567901E-11  -1.29621379526227E-18  -5.10361469347854E-03  -5.10361469390030E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21759810936094E-10   0.00000000000000E+00   4.21759810936094E-10
      4.36118321763152E-18  -2.87181170564650E-01  -2.87074091795473E-01   0.00000000000000E+00  -9.82832614227243E-12
     -1.38458232157807E-22  -3.30046117436964E-10  -3.39874443579375E-10  -3.06496942236926E-18
      1.28084390699694E-08
      0.00000000000000E+00   7.45779266125117E-14   0.00000000000000E+00   1.42297419239093E-14  -4.79685821215676E-23
     -7.45525943365995E-11  -7.45383645947235E-11  -1.29692833545261E-18  -4.83365654451983E-03  -4.83365654498038E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60553199699096E-10   0.00000000000000E+00   4.60553199699096E-10
      4.37860780218601E-18  -2.94162980641587E-01  -2.94041363955250E-01   0.00000000000000E+00  -1.30701452176340E-11
     -1.39404751164878E-22  -3.72944689886619E-10  -3.86014835104392E-10  -3.08167946673340E-18
      1.28584390699694E-08
      0.00000000000000E+00   6.46586949940988E-14   0.00000000000000E+00   1.55327658369831E-14  -4.79377402771944E-23
     -6.46903558729892E-11  -6.46748231072001E-11  -1.29744078071924E-18  -4.61900235528883E-03  -4.61900235582885E-03
      0.00000000000000E+00   0.00000000000000E+00   5.40010150946931E-10   0.00000000000000E+00   5.40010150946931E-10
      4.40560830973336E-18  -3.06936419967946E-01  -3.06786660254098E-01   0.00000000000000E+00  -1.94574331513456E-11
     -1.41226519028324E-22  -4.55877894688248E-10  -4.75335327839735E-10  -3.10816752901412E-18
      1.29084390699694E-08
      0.00000000000000E+00   5.49231528501010E-14   0.00000000000000E+00   1.66218416253614E-14  -4.79005793811128E-23
     -5.48800128959443E-11  -5.48633910543668E-11  -1.29752923794698E-18  -4.59436094737968E-03  -4.59436094794833E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68649926885936E-10   0.00000000000000E+00   5.68649926885936E-10
      4.43404080607766E-18  -3.21409043543551E-01  -3.21247168721830E-01   0.00000000000000E+00  -2.29306240299088E-11
     -1.43319524445175E-22  -4.90855911801515E-10  -5.13786535831567E-10  -3.13651156813067E-18
      1.29584390699694E-08
      0.00000000000000E+00   2.46143895716172E-14   0.00000000000000E+00   4.13651730678973E-14  -4.78381065842972E-23
     -2.46201971814801E-11  -2.45788320084601E-11  -1.29617852348659E-18  -5.41895728707542E-03  -5.41895728758704E-03
      0.00000000000000E+00   0.00000000000000E+00   5.11625800936092E-10   0.00000000000000E+00   5.11625800936092E-10
      4.45962209612446E-18  -3.35743816502590E-01  -3.35590366981826E-01   0.00000000000000E+00  -2.19272018687123E-11
     -1.45271965828300E-22  -4.65119767058770E-10  -4.87046968927627E-10  -3.16344357263787E-18
      1.30084390699694E-08
      0.00000000000000E+00  -1.16918350465182E-13   0.00000000000000E+00   1.73496625588280E-13  -4.76492445480317E-23
      1.16746781063847E-10   1.16920277689388E-10  -1.28788083277989E-18  -1.03687660623401E-02  -1.03687660625984E-02
      0.00000000000000E+00   0.00000000000000E+00   2.58301729911219E-10   0.00000000000000E+00   2.58301729911219E-10
      4.47253718262002E-18  -3.49768014816953E-01  -3.49649799650393E-01   0.00000000000000E+00  -1.40943492115132E-11
     -1.46509684626413E-22  -3.61127658388919E-10  -3.75222007600578E-10  -3.18465634984013E-18
      1.30584390699694E-08
      0.00000000000000E+00  -6.03603612927866E-13   0.00000000000000E+00   5.85045373229042E-13  -4.70299166792512E-23
      6.03052200409484E-10   6.03637245782666E-10  -1.25571326618263E-18  -2.91882903614645E-02  -2.91882903609199E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.44660234563403E-10   0.00000000000000E+00  -5.44660234563403E-10
      4.44530417089185E-18  -3.64705469048955E-01  -3.64686898247252E-01   0.00000000000000E+00   1.04315856667841E-11
     -1.45640612481859E-22  -6.94085968859028E-11  -5.89770112192643E-11  -3.18959090470922E-18
      1.30834390699694E-08
      0.00000000000000E+00  -9.36816319516773E-13   0.00000000000000E+00   7.98475004702871E-13  -4.65816368181534E-23
      9.36039670087154E-10   9.36838145091811E-10  -1.23158033659178E-18  -4.30109912493130E-02  -4.30109912482366E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.07638660152455E-09   0.00000000000000E+00  -1.07638660152455E-09
      4.41839450585374E-18  -3.72441327266007E-01  -3.72485309282378E-01   0.00000000000000E+00   2.55642761968362E-11
     -1.44546116328566E-22   1.13984180236017E-10   1.39548456432708E-10  -3.18681416926195E-18
      1.31171890699694E-08
      0.00000000000000E+00  -1.19765537318615E-12   0.00000000000000E+00   5.37997566726862E-13  -4.58782920760249E-23
      1.19715362294544E-09   1.19769162051212E-09  -1.19129504121563E-18  -6.54937368577656E-02  -6.54937368563056E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.45995771860196E-09   0.00000000000000E+00  -1.45995771860196E-09
      4.36912093285092E-18  -3.82754688287042E-01  -3.82837338200073E-01   0.00000000000000E+00   3.49367359098846E-11
     -1.42469441820085E-22   2.27329362180095E-10   2.62266098089837E-10  -3.17782589163528E-18
      1.31399703199694E-08
      0.00000000000000E+00  -1.35195453169479E-12   0.00000000000000E+00   4.86627831941913E-13  -4.53836034748546E-23
      1.35145972457075E-09   1.35194635240264E-09  -1.16154738025260E-18  -8.16629055619555E-02  -8.16629055603078E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.64771256419693E-09   0.00000000000000E+00  -1.64771256419693E-09
      4.33158398099781E-18  -3.89484550206425E-01  -3.89577757389304E-01   0.00000000000000E+00   3.80463559259631E-11
     -1.40897463562316E-22   2.57719855868468E-10   2.95766211794290E-10  -3.17003660074521E-18
      1.31553476637194E-08
      0.00000000000000E+00  -1.45270820841145E-12   0.00000000000000E+00   4.70111730459436E-13  -4.50393935873313E-23
      1.45227135195241E-09   1.45274146368283E-09  -1.14059263987666E-18  -9.28406559820438E-02  -9.28406559802991E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.74468590257492E-09   0.00000000000000E+00  -1.74468590257492E-09
      4.30475534613813E-18  -3.93881247223071E-01  -3.93973252417397E-01   0.00000000000000E+00   3.90417540582838E-11
     -1.39782649444041E-22   2.52902684833936E-10   2.91944438892080E-10  -3.16416270626147E-18
      1.31761070777819E-08
      0.00000000000000E+00  -1.57908656680901E-12   0.00000000000000E+00   4.39528628573588E-13  -4.45268879974286E-23
      1.57863078053947E-09   1.57907030916800E-09  -1.11153087751129E-18  -1.08058043856044E-01  -1.08058043854225E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81847147288173E-09   0.00000000000000E+00  -1.81847147288173E-09
      4.26700494387174E-18  -3.99479973355224E-01  -3.99555428186117E-01   0.00000000000000E+00   3.95350611692978E-11
     -1.38216909496089E-22   1.99866102544488E-10   2.39401163713648E-10  -3.15547406636045E-18
      1.32041322867663E-08
      0.00000000000000E+00  -1.82155667303688E-12   0.00000000000000E+00   5.54852488729649E-13  -4.35276443299756E-23
      1.82101085687517E-09   1.82156570936386E-09  -1.07129200442151E-18  -1.28607056283635E-01  -1.28607056281729E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90627162636133E-09   0.00000000000000E+00  -1.90627162636133E-09
      4.21358128316198E-18  -4.06188968395127E-01  -4.06215693481782E-01   0.00000000000000E+00   4.00800378082652E-11
     -1.35986987962978E-22   4.46258791893908E-11   8.47059169975200E-11  -3.14228927874047E-18
      1.32419663188952E-08
      0.00000000000000E+00  -2.45445875713394E-12   0.00000000000000E+00   9.39212537216273E-13  -4.02581159641236E-23
      2.45349477991665E-09   2.45443399245383E-09  -1.01481071755673E-18  -1.56469378819378E-01  -1.56469378817297E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08023338278919E-09   0.00000000000000E+00  -2.08023338278919E-09
      4.13487766652191E-18  -4.12694374001890E-01  -4.12576538159086E-01   0.00000000000000E+00   4.25820459788392E-11
     -1.32590259505189E-22  -4.16782655643342E-10  -3.74200609664636E-10  -3.12006694896518E-18
      1.32919663188952E-08
      0.00000000000000E+00  -4.22926645893219E-12   0.00000000000000E+00   1.84290556070782E-12  -2.58650992331730E-23
      4.22744921647609E-09   4.22929212203677E-09  -9.39933797227814E-19  -1.91722067304575E-01  -1.91722067302219E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35553191101458E-09   0.00000000000000E+00  -2.35553191101458E-09
      4.01710107097118E-18  -4.11813372802625E-01  -4.11223141602584E-01   0.00000000000000E+00   4.85323863045629E-11
     -1.26966443397294E-22  -1.92229259732666E-09  -1.87376021102222E-09  -3.07716727374336E-18
      1.33419663188952E-08
      0.00000000000000E+00  -7.24535578409016E-12   0.00000000000000E+00   3.03781038951464E-12   7.70834751299645E-24
      7.24232501684402E-09   7.24536282723355E-09  -8.74913886372404E-19  -2.21032579451010E-01  -2.21032579448427E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58295745487238E-09   0.00000000000000E+00  -2.58295745487238E-09
      3.88795319822756E-18  -3.93452924794922E-01  -3.91984170694417E-01   0.00000000000000E+00   5.42686149406887E-11
     -1.19893723655903E-22  -4.71667398730173E-09  -4.66240537236116E-09  -3.01303931185516E-18
      1.33919663188952E-08
      0.00000000000000E+00  -1.04548701258072E-11   0.00000000000000E+00   3.20437894314160E-12   4.67754588711382E-23
      1.04516505512356E-08   1.04548549301788E-08  -8.27479010296985E-19  -2.42070062333931E-01  -2.42070062331185E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74678922938553E-09   0.00000000000000E+00  -2.74678922938553E-09
      3.75061373675828E-18  -3.53552336884609E-01  -3.51124040406896E-01   0.00000000000000E+00   5.64683546465801E-11
     -1.11867344129049E-22  -7.76453405543975E-09  -7.70806570079328E-09  -2.92313472646130E-18
      1.34419663188952E-08
      0.00000000000000E+00  -1.24388082942270E-11   0.00000000000000E+00   1.97972678902975E-12   7.25928404000975E-23
      1.24367981137592E-08   1.24387778405484E-08  -7.97120991339288E-19  -2.55924280069661E-01  -2.55924280066797E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86393135098072E-09   0.00000000000000E+00  -2.86393135098072E-09
      3.60741716920925E-18  -2.96639932787761E-01  -2.93623448908730E-01   0.00000000000000E+00   5.11260537967484E-11
     -1.03950644902134E-22  -9.62597254336431E-09  -9.57484648956766E-09  -2.81029617786996E-18
      1.34919663188952E-08
      0.00000000000000E+00  -1.32072732104423E-11   0.00000000000000E+00   7.72021564324623E-13   8.25515363006857E-23
      1.32065448874987E-08   1.32073169090631E-08  -7.76953427812510E-19  -2.65750392664675E-01  -2.65750392661772E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90289041858832E-09   0.00000000000000E+00  -2.90289041858832E-09
      3.46227264827983E-18  -2.34529781533814E-01  -2.31283373269022E-01   0.00000000000000E+00   3.89716825640773E-11
     -9.58003817915224E-23  -1.03433981730388E-08  -1.03044264904748E-08  -2.68531922046732E-18
      1.35169663188952E-08
      0.00000000000000E+00  -1.32695439422691E-11   0.00000000000000E+00   1.33482357032386E-13   8.34337069284380E-23
      1.32694618818000E-08   1.32695953641571E-08  -7.68918650005650E-19  -2.69879602542859E-01  -2.69879602539944E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91501975960232E-09   0.00000000000000E+00  -2.91501975960232E-09
      3.38939715428977E-18  -2.03502202724406E-01  -2.00239962938836E-01   0.00000000000000E+00   3.07810301319234E-11
     -9.19242472547962E-23  -1.03853566346866E-08  -1.03545756045547E-08  -2.62047850428412E-18
      1.35507163188952E-08
      0.00000000000000E+00  -1.32710134580644E-11   0.00000000000000E+00   1.04297982559986E-14   8.21431619535340E-23
      1.32709934415421E-08   1.32710038713404E-08  -7.59284089431756E-19  -2.75036489315429E-01  -2.75036489312542E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88762998203161E-09   0.00000000000000E+00  -2.88762998203161E-09
      3.29193964239621E-18  -1.63291770201907E-01  -1.60020424359344E-01   0.00000000000000E+00   2.48711979378346E-11
     -8.78942928192702E-23  -1.04082450872466E-08  -1.03833738893089E-08  -2.53265555296445E-18
      1.35734975688952E-08
      0.00000000000000E+00  -1.31587791891968E-11   0.00000000000000E+00  -2.35317553759647E-13   8.01263356747702E-23
      1.31590295271853E-08   1.31587942096316E-08  -7.53510478070778E-19  -2.78257897450726E-01  -2.78257897447851E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87508988634578E-09   0.00000000000000E+00  -2.87508988634578E-09
      3.22644150092289E-18  -1.36876196016880E-01  -1.33636233118557E-01   0.00000000000000E+00   2.09902795660769E-11
     -8.55599136903505E-23  -1.03046946028518E-08  -1.02837043232858E-08  -2.47293102285211E-18
      1.35888749126452E-08
      0.00000000000000E+00  -1.30502187098175E-11   0.00000000000000E+00  -3.41290280848080E-13   7.85083444313680E-23
      1.30505472443716E-08   1.30502059540909E-08  -7.49826937752392E-19  -2.80361359075366E-01  -2.80361359072502E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86324202454732E-09   0.00000000000000E+00  -2.86324202454732E-09
      3.18241244407198E-18  -1.19531593488677E-01  -1.16322098375672E-01   0.00000000000000E+00   1.86660793656152E-11
     -8.38754979321721E-23  -1.02056300089091E-08  -1.01869639295435E-08  -2.43258550631959E-18
      1.36096343267077E-08
      0.00000000000000E+00  -1.29081349013574E-11   0.00000000000000E+00  -3.30636487196141E-13   7.66305100398720E-23
      1.29084731584671E-08   1.29081425219800E-08  -7.44795879056766E-19  -2.83241698817597E-01  -2.83241698814762E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83500288133373E-09   0.00000000000000E+00  -2.83500288133373E-09
      3.12355944539000E-18  -9.73105140820979E-02  -9.41368674853668E-02   0.00000000000000E+00   1.63946660401817E-11
     -8.09818242543841E-23  -1.00895343066864E-08  -1.00731396406463E-08  -2.37876356633323E-18
      1.36376595356921E-08
      0.00000000000000E+00  -1.26232325265397E-11   0.00000000000000E+00  -4.93360418791403E-13   7.47945480313533E-23
      1.26237436180131E-08   1.26232502575944E-08  -7.37422505222698E-19  -2.87367599380222E-01  -2.87367599377436E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78577199727347E-09   0.00000000000000E+00  -2.78577199727347E-09
      3.04548760298359E-18  -7.02670084235833E-02  -6.71675948987604E-02   0.00000000000000E+00   1.35752125828090E-11
     -7.24258438701462E-23  -9.85105347290362E-09  -9.83747826032088E-09  -2.30806509776089E-18
      1.36754935678210E-08
      0.00000000000000E+00  -1.18886583183539E-11   0.00000000000000E+00  -9.45817710424579E-13   7.63340101403687E-23
      1.18895426973855E-08   1.18885968796751E-08  -7.23437482371179E-19  -2.94421444376577E-01  -2.94421444373910E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.66737896938555E-09   0.00000000000000E+00  -2.66737896938555E-09
      2.94456990135588E-18  -4.26295197186500E-02  -3.97242524194450E-02   0.00000000000000E+00   9.97676995808621E-12
     -3.91607004218663E-23  -9.23119468024767E-09  -9.22121791028963E-09  -2.22113241898470E-18
      1.37254935678210E-08
      0.00000000000000E+00  -1.06322223133549E-11   0.00000000000000E+00  -1.22179815963015E-12   8.93594126555232E-23
      1.06334167258858E-08   1.06321949277263E-08  -6.95019111983844E-19  -3.07273421578196E-01  -3.07273421575746E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44995309321976E-09   0.00000000000000E+00  -2.44995309321976E-09
      2.82207224669490E-18  -2.34267832192707E-02  -2.08488488545949E-02   0.00000000000000E+00   6.22782604706697E-12
      3.54667578427431E-23  -8.18846966055356E-09  -8.18224183450645E-09  -2.12705313471105E-18
      1.37754935678210E-08
      0.00000000000000E+00  -9.65710673842261E-12   0.00000000000000E+00  -9.42880170542941E-13   1.07418761953387E-22
      9.65807148577572E-09   9.65712860560529E-09  -6.61641977703034E-19  -3.21758781881491E-01  -3.21758781879223E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26854221744585E-09   0.00000000000000E+00  -2.26854221744585E-09
      2.70864513582260E-18  -1.50003432557766E-02  -1.26724558322537E-02   0.00000000000000E+00   3.86565035663197E-12
      1.02676629366230E-22  -7.39245203851619E-09  -7.38858638815945E-09  -2.04700315811957E-18
      1.38254935678210E-08
      0.00000000000000E+00  -9.06920857555723E-12   0.00000000000000E+00  -5.62429613760268E-13   1.21940829655234E-22
      9.06976367283531E-09   9.06920124322167E-09  -6.28390002756413E-19  -3.36082037346389E-01  -3.36082037344235E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15351339065282E-09   0.00000000000000E+00  -2.15351339065282E-09
      2.60096946628996E-18  -1.09679922366484E-02  -8.78909521987842E-03   0.00000000000000E+00   2.64204202707480E-12
      1.50541927226260E-22  -6.91832989459605E-09  -6.91568785256882E-09  -1.97257946353355E-18
      1.38754935678210E-08
      0.00000000000000E+00  -8.75813045063534E-12   0.00000000000000E+00  -2.90766509294792E-13   1.29554303938856E-22
      8.75845383685523E-09   8.75816307034607E-09  -5.95916725941189E-19  -3.50111255136899E-01  -3.50111255134771E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12848666105554E-09   0.00000000000000E+00  -2.12848666105554E-09
      2.49454513323719E-18  -8.70954580405191E-03  -6.62075871807870E-03   0.00000000000000E+00   2.05864475416042E-12
      1.79373107722698E-22  -6.63173505404484E-09  -6.62967640929050E-09  -1.89862840729600E-18
      1.39254935678210E-08
      0.00000000000000E+00  -8.78164270336046E-12   0.00000000000000E+00   3.90451495809625E-14   1.31247401183844E-22
      8.78158416625809E-09   8.78162321140780E-09  -5.61252106648456E-19  -3.65079466418180E-01  -3.65079466415880E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29946691192725E-09   0.00000000000000E+00  -2.29946691192725E-09
      2.37957178764082E-18  -7.28124729420845E-03  -5.23893674967348E-03   0.00000000000000E+00   1.83307907377981E-12
      1.93537784428988E-22  -6.48398937855454E-09  -6.48215629948057E-09  -1.81831968099237E-18
      1.39504935678210E-08
      0.00000000000000E+00  -8.84170916149418E-12   0.00000000000000E+00   1.34228227630101E-13   1.29023320020286E-22
      8.84155630751463E-09   8.84169053574239E-09  -5.43271201008257E-19  -3.72817992675982E-01  -3.72817992673564E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41784040588574E-09   0.00000000000000E+00  -2.41784040588574E-09
      2.31912577749368E-18  -6.73544571341685E-03  -4.71150450150934E-03   0.00000000000000E+00   1.73941480397325E-12
      1.94234449956649E-22  -6.42558954466090E-09  -6.42385012985673E-09  -1.77585457648542E-18
      1.39842435678210E-08
      0.00000000000000E+00  -8.83151439566415E-12   0.00000000000000E+00   3.44441462840740E-16   1.21551540373661E-22
      8.83148077191382E-09   8.83148111635540E-09  -5.19348580389147E-19  -3.83116805091739E-01  -3.83116805089306E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43337025408855E-09   0.00000000000000E+00  -2.43337025408855E-09
      2.23699953141819E-18  -6.13987236044694E-03  -4.12403941082275E-03   0.00000000000000E+00   1.56346215636476E-12
      1.86694699017520E-22  -6.39967432442344E-09  -6.39811086226689E-09  -1.71765095102904E-18
      1.40070248178210E-08
      0.00000000000000E+00  -8.77447881385828E-12   0.00000000000000E+00  -1.09181824230264E-13   1.13574412773463E-22
      8.77457919471407E-09   8.77447001288996E-09  -5.03746345659640E-19  -3.89830888539873E-01  -3.89830888537476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39720112539290E-09   0.00000000000000E+00  -2.39720112539290E-09
      2.18238829328033E-18  -5.79798928861223E-03  -3.78872209713553E-03   0.00000000000000E+00   1.45279644695849E-12
      1.76034036288484E-22  -6.37872168394420E-09  -6.37726888749707E-09  -1.67864194762069E-18
      1.40224021615710E-08
      0.00000000000000E+00  -8.71477973467338E-12   0.00000000000000E+00  -1.78114911975910E-13   1.07002323754032E-22
      8.71492277282834E-09   8.71474465791647E-09  -4.93557008148966E-19  -3.94214307111841E-01  -3.94214307109493E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34777575879100E-09   0.00000000000000E+00  -2.34777575879100E-09
      2.14628573838949E-18  -5.59411218137940E-03  -3.58808961359840E-03   0.00000000000000E+00   1.35525742553621E-12
      1.66562234291980E-22  -6.36832415655114E-09  -6.36696889912544E-09  -1.65272873024052E-18
      1.40431615756335E-08
      0.00000000000000E+00  -8.60199439738254E-12   0.00000000000000E+00  -2.55565263400373E-13   9.71132958836774E-23
      8.60221446118273E-09   8.60195889591942E-09  -4.80592763351531E-19  -3.99789722756132E-01  -3.99789722753895E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23683053644520E-09   0.00000000000000E+00  -2.23683053644520E-09
      2.09985044709578E-18  -5.35584924804280E-03  -3.35040586118752E-03   0.00000000000000E+00   1.21977011693303E-12
      1.51741170707405E-22  -6.36634812959133E-09  -6.36512835947425E-09  -1.61925768374425E-18
      1.40711867846178E-08
      0.00000000000000E+00  -8.38211809650772E-12   0.00000000000000E+00  -3.76044737087407E-13   8.27481169278727E-23
      8.38253350535639E-09   8.38215746061938E-09  -4.65098719154769E-19  -4.06452984309394E-01  -4.06452984307383E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01054292016669E-09   0.00000000000000E+00  -2.01054292016669E-09
      2.04350456158605E-18  -5.08797501033798E-03  -3.08048716130950E-03   0.00000000000000E+00   1.03299606362747E-12
      1.29455892277005E-22  -6.37264753651644E-09  -6.37161454045268E-09  -1.57840584243128E-18
      1.41090208167468E-08
      0.00000000000000E+00  -7.89010583928700E-12   0.00000000000000E+00  -6.33673896236911E-13   6.32903547156791E-23
      7.89077870990645E-09   7.89014503601027E-09  -4.50359800702437E-19  -4.12841265119329E-01  -4.12841265117854E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47454658512309E-09   0.00000000000000E+00  -1.47454658512309E-09
      1.98771651870893E-18  -4.82277314726581E-03  -2.80142637667635E-03   0.00000000000000E+00   6.58935782201928E-13
      9.83849175917584E-23  -6.41625738666947E-09  -6.41559845088717E-09  -1.53735671800650E-18
      1.41590208167468E-08
      0.00000000000000E+00  -6.45043958355902E-12   0.00000000000000E+00  -1.42012531772644E-12   3.94064224363433E-23
      6.45185098859036E-09   6.45043086327268E-09  -4.54365659109364E-19  -4.11611639426904E-01  -4.11611639426950E-01
      0.00000000000000E+00   0.00000000000000E+00   4.61402634592520E-11   0.00000000000000E+00   4.61402634592520E-11
      1.99002353188190E-18  -4.61252533631952E-03  -2.56566584152392E-03   0.00000000000000E+00  -2.01539043232921E-13
      5.92618678875548E-23  -6.49636958768875E-09  -6.49657112673193E-09  -1.53565787277253E-18
      1.42090208167468E-08
      0.00000000000000E+00  -3.85059060742556E-12   0.00000000000000E+00  -2.60340250004626E-12   1.55403193222000E-23
      3.85317363119773E-09   3.85057022869770E-09  -5.02089427394544E-19  -3.92718775968770E-01  -3.92718775971442E-01
      0.00000000000000E+00   0.00000000000000E+00   2.67163635409836E-09   0.00000000000000E+00   2.67163635409836E-09
      2.12360534958681E-18  -4.60104425223130E-03  -2.54610050263184E-03   0.00000000000000E+00  -1.76313706044992E-12
      1.85109356272144E-23  -6.52044344573565E-09  -6.52220658279608E-09  -1.62151592219227E-18
      1.42590208167468E-08
      0.00000000000000E+00  -1.15513125985906E-12   0.00000000000000E+00  -2.70224373323756E-12  -1.28758770456141E-23
      1.15781232710960E-09   1.15511008337635E-09  -6.03207137308498E-19  -3.52286841692742E-01  -3.52286841698039E-01
      0.00000000000000E+00   0.00000000000000E+00   5.29726391134430E-09   0.00000000000000E+00   5.29726391134430E-09
      2.38846854515403E-18  -5.49015982389025E-03  -3.45722713760455E-03   0.00000000000000E+00  -4.49498930209862E-12
     -3.28834783770388E-23  -6.44787900541853E-09  -6.45237399472066E-09  -1.78526140784553E-18
      1.43090208167468E-08
      0.00000000000000E+00   4.22210256943000E-13   0.00000000000000E+00  -1.64020469718951E-12  -3.46709859649919E-23
     -4.20598934061368E-10  -4.22239138758592E-10  -7.40318696438829E-19  -2.95078987666747E-01  -2.95078987673302E-01
      0.00000000000000E+00   0.00000000000000E+00   6.55500965237833E-09   0.00000000000000E+00   6.55500965237833E-09
      2.71621902777295E-18  -1.07487111738722E-02  -8.81647845455278E-03   0.00000000000000E+00  -8.93332906609186E-12
     -7.07843843683603E-23  -6.12383718455356E-09  -6.13277051361972E-09  -1.97590033133412E-18
      1.43590208167468E-08
      0.00000000000000E+00   1.52820458239604E-12   0.00000000000000E+00  -1.21310860270927E-12  -4.15367431794173E-23
     -1.52698497541242E-09  -1.52819808401517E-09  -8.76610296495429E-19  -2.32974165897997E-01  -2.32974165904641E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64442868724255E-09   0.00000000000000E+00   6.64442868724255E-09
      3.04844046213507E-18  -3.02022614739972E-02  -2.85903085253316E-02   0.00000000000000E+00  -1.65347187455748E-11
     -8.16405544039230E-23  -5.09969588448173E-09  -5.11623060322738E-09  -2.17183016563964E-18
      1.43840208167468E-08
      0.00000000000000E+00   1.92433093397210E-12   0.00000000000000E+00  -9.32262849946011E-13  -4.27411675297083E-23
     -1.92345721573652E-09  -1.92438947858651E-09  -9.40226853343303E-19  -2.01978833841343E-01  -2.01978833847721E-01
      0.00000000000000E+00   0.00000000000000E+00   6.37778114834007E-09   0.00000000000000E+00   6.37778114834007E-09
      3.20788499084358E-18  -4.42423740281151E-02  -4.28392559702818E-02   0.00000000000000E+00  -2.47436684460528E-11
     -8.57642440722036E-23  -4.42864800130741E-09  -4.45339166975355E-09  -2.26765813750027E-18
      1.44177708167468E-08
      0.00000000000000E+00   2.14310509800043E-12   0.00000000000000E+00  -4.88956863528072E-13  -4.38684289687094E-23
     -2.14259283415789E-09  -2.14308179102146E-09  -1.01893508705828E-18  -1.61821948525744E-01  -1.61821948531743E-01
      0.00000000000000E+00   0.00000000000000E+00   5.99939376161154E-09   0.00000000000000E+00   5.99939376161154E-09
      3.41036453029796E-18  -6.68541292465048E-02  -6.56391298603049E-02   0.00000000000000E+00  -3.35521849939837E-11
     -9.22015275548819E-23  -3.82275978559607E-09  -3.85631197059015E-09  -2.39142944323969E-18
      1.44405520667468E-08
      0.00000000000000E+00   2.12188896370549E-12   0.00000000000000E+00  -1.44500086710384E-13  -4.46142415042537E-23
     -2.12171037790437E-09  -2.12185487799112E-09  -1.06860721454529E-18  -1.35455731424529E-01  -1.35455731430163E-01
      0.00000000000000E+00   0.00000000000000E+00   5.63353043018996E-09   0.00000000000000E+00   5.63353043018996E-09
      3.53870339541073E-18  -8.30635867702056E-02  -8.19571678377858E-02   0.00000000000000E+00  -4.26098624878013E-11
     -9.66947779869582E-23  -3.46906568971084E-09  -3.51167555219873E-09  -2.47009618086544E-18
      1.44559294104968E-08
      0.00000000000000E+00   2.05704657923698E-12   0.00000000000000E+00   4.82369105580156E-15  -4.51183588059618E-23
     -2.05709381664257E-09  -2.05708899295156E-09  -1.10038019115543E-18  -1.18154046872418E-01  -1.18154046877780E-01
      0.00000000000000E+00   0.00000000000000E+00   5.36220688714839E-09   0.00000000000000E+00   5.36220688714839E-09
      3.62115989397303E-18  -9.42540477838041E-02  -9.32127062684916E-02   0.00000000000000E+00  -4.89716189927099E-11
     -9.97447919821554E-23  -3.25614627520413E-09  -3.30511789419694E-09  -2.52077970281760E-18
      1.44766888245593E-08
      0.00000000000000E+00   1.94380201826010E-12   0.00000000000000E+00   6.09104358453108E-14  -4.57717003314014E-23
     -1.94385588942560E-09  -1.94379497898980E-09  -1.14012508424623E-18  -9.60117109626307E-02  -9.60117109676549E-02
      0.00000000000000E+00   0.00000000000000E+00   5.02426349573947E-09   0.00000000000000E+00   5.02426349573947E-09
      3.72546066024019E-18  -1.09475016713063E-01  -1.08504454840208E-01   0.00000000000000E+00  -5.42307435908809E-11
     -1.03836601228194E-22  -3.02623777315865E-09  -3.08046851674964E-09  -2.58533557599396E-18
      1.45047140335436E-08
      0.00000000000000E+00   1.72686474897592E-12   0.00000000000000E+00   1.75880290769317E-13  -4.65553453883371E-23
     -1.72698258934260E-09  -1.72680670905187E-09  -1.18703273374543E-18  -6.91451595838356E-02  -6.91451595883483E-02
      0.00000000000000E+00   0.00000000000000E+00   4.51262366905042E-09   0.00000000000000E+00   4.51262366905042E-09
      3.85192788163316E-18  -1.30028263241418E-01  -1.29150536984081E-01   0.00000000000000E+00  -5.97741254864972E-11
     -1.09273652869744E-22  -2.72604283451197E-09  -2.78581695999858E-09  -2.66489514788773E-18
      1.45425480656725E-08
      0.00000000000000E+00   1.28233622089149E-12   0.00000000000000E+00   4.10171109370208E-13  -4.73111272925144E-23
     -1.28268339814924E-09  -1.28227322703992E-09  -1.23317585249744E-18  -4.18977500018238E-02  -4.18977500054346E-02
      0.00000000000000E+00   0.00000000000000E+00   3.61082032317996E-09   0.00000000000000E+00   3.61082032317996E-09
      3.98853977375206E-18  -1.57903261756958E-01  -1.57169607514481E-01   0.00000000000000E+00  -6.19555712558009E-11
     -1.16063261461561E-22  -2.26659152488410E-09  -2.32854709614002E-09  -2.75536392125462E-18
      1.45925480656725E-08
      0.00000000000000E+00   6.82957465875169E-13   0.00000000000000E+00   5.00905275140465E-13  -4.77755027374590E-23
     -6.83446251386887E-10  -6.82945346111794E-10  -1.26413992642046E-18  -2.31066633918685E-02  -2.31066633942548E-02
      0.00000000000000E+00   0.00000000000000E+00   2.38633420716044E-09   0.00000000000000E+00   2.38633420716044E-09
      4.10785648411008E-18  -1.93014340697237E-01  -1.92477655046853E-01   0.00000000000000E+00  -5.54331801969336E-11
     -1.23237222392314E-22  -1.64795568085159E-09  -1.70338886104865E-09  -2.84371655768963E-18
      1.46425480656725E-08
      0.00000000000000E+00   3.31559501319172E-13   0.00000000000000E+00   3.11558363088480E-13  -4.79418512422138E-23
     -3.31888965644637E-10  -3.31577407281597E-10  -1.27759475629332E-18  -1.48582161376529E-02  -1.48582161391741E-02
      0.00000000000000E+00   0.00000000000000E+00   1.52119683089575E-09   0.00000000000000E+00   1.52119683089575E-09
      4.18391632565487E-18  -2.22018713759499E-01  -2.21643901401026E-01   0.00000000000000E+00  -4.43041452778292E-11
     -1.28454087777070E-22  -1.14531527833621E-09  -1.18961942361417E-09  -2.90632156936155E-18
      1.46925480656725E-08
      0.00000000000000E+00   1.94618998142749E-13   0.00000000000000E+00   1.22672637178204E-13  -4.80016325130260E-23
     -1.94781008735417E-10  -1.94658336098287E-10  -1.28426729253755E-18  -1.08936005611529E-02  -1.08936005621679E-02
      0.00000000000000E+00   0.00000000000000E+00   1.01504635607051E-09   0.00000000000000E+00   1.01504635607051E-09
      4.23466864345840E-18  -2.42735653225666E-01  -2.42477175762046E-01   0.00000000000000E+00  -3.16235389366448E-11
     -1.31949854613621E-22  -7.88764481035429E-10  -8.20388019972206E-10  -2.95040135092085E-18
      1.47425480656725E-08
      0.00000000000000E+00   1.41532740036799E-13   0.00000000000000E+00   4.84593846452311E-14  -4.80220687563246E-23
     -1.41541321565921E-10  -1.41492862181324E-10  -1.28833626236212E-18  -8.66464343076709E-03  -8.66464343147786E-03
      0.00000000000000E+00   0.00000000000000E+00   7.10770271845024E-10   0.00000000000000E+00   7.10770271845024E-10
      4.27020715705065E-18  -2.56365823437105E-01  -2.56186464891855E-01   0.00000000000000E+00  -2.05473748369181E-11
     -1.34137070081845E-22  -5.48730034826640E-10  -5.69277409663693E-10  -2.98187089468852E-18
      1.47925480656725E-08
      0.00000000000000E+00   1.15908058355899E-13   0.00000000000000E+00   2.49004686117373E-14  -4.80242651111998E-23
     -1.15977143668481E-10  -1.15952243199917E-10  -1.29117743265430E-18  -7.25135129821959E-03  -7.25135129877181E-03
      0.00000000000000E+00   0.00000000000000E+00   5.52226833904072E-10   0.00000000000000E+00   5.52226833904072E-10
      4.29781849874585E-18  -2.66096371511590E-01  -2.65958919173509E-01   0.00000000000000E+00  -1.41137286463831E-11
     -1.35601566061854E-22  -4.22160862057642E-10  -4.36274590704161E-10  -3.00664106609155E-18
      1.48175480656725E-08
      0.00000000000000E+00   1.05437758314241E-13   0.00000000000000E+00   2.20064327749750E-14  -4.80214819700351E-23
     -1.05419405498215E-10  -1.05397399065488E-10  -1.29234594855389E-18  -6.70994184573796E-03  -6.70994184622743E-03
      0.00000000000000E+00   0.00000000000000E+00   4.89472262893848E-10   0.00000000000000E+00   4.89472262893848E-10
      4.31005530531820E-18  -2.70194849268536E-01  -2.70073843895846E-01   0.00000000000000E+00  -1.14882681791911E-11
     -1.36189265154009E-22  -3.72586595649072E-10  -3.84074863828399E-10  -3.01770935676431E-18
      1.48512980656725E-08
      0.00000000000000E+00   9.77228003888085E-14   0.00000000000000E+00   1.33187755179663E-14  -4.80147548096963E-23
     -9.77209489021964E-11  -9.77076301267265E-11  -1.29368520098300E-18  -6.11924125626695E-03  -6.11924125672522E-03
      0.00000000000000E+00   0.00000000000000E+00   4.58268644693808E-10   0.00000000000000E+00   4.58268644693808E-10
      4.32552187207661E-18  -2.75324590402144E-01  -2.75210993748317E-01   0.00000000000000E+00  -1.04278724587582E-11
     -1.36898858393787E-22  -3.50133142108241E-10  -3.60561014567136E-10  -3.03183667109361E-18
      1.48740793156725E-08
      0.00000000000000E+00   9.29468740540171E-14   0.00000000000000E+00   1.28185918499677E-14  -4.80088719107041E-23
     -9.30005449286511E-11  -9.29877263368492E-11  -1.29449123354540E-18  -5.78029633758333E-03  -5.78029633801768E-03
      0.00000000000000E+00   0.00000000000000E+00   4.34344194872685E-10   0.00000000000000E+00   4.34344194872685E-10
      4.33541677576606E-18  -2.78534925692304E-01  -2.78427379989921E-01   0.00000000000000E+00  -9.45583074195498E-12
     -1.37329272796941E-22  -3.31900637793738E-10  -3.41356468535830E-10  -3.04092554222066E-18
      1.49048340031725E-08
      0.00000000000000E+00   8.73443450843579E-14   0.00000000000000E+00   1.22134004419453E-14  -4.79988537687832E-23
     -8.73839930827151E-11  -8.73717796823212E-11  -1.29542428024539E-18  -5.40672340328092E-03  -5.40672340370347E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22552613856588E-10   0.00000000000000E+00   4.22552613856588E-10
      4.34841224935752E-18  -2.82837190989841E-01  -2.82731591101467E-01   0.00000000000000E+00  -9.30315450856377E-12
     -1.37893963648216E-22  -3.25877679665549E-10  -3.35180834174250E-10  -3.05298796911213E-18
      1.49463528312975E-08
      0.00000000000000E+00   8.04559897937934E-14   0.00000000000000E+00   1.20838216958747E-14  -4.79819339541104E-23
     -8.05018115883442E-11  -8.04897277666963E-11  -1.29643162001673E-18  -5.02436601534623E-03  -5.02436601577211E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25873193595876E-10   0.00000000000000E+00   4.25873193595876E-10
      4.36609400528547E-18  -2.89119757778574E-01  -2.89010943247949E-01   0.00000000000000E+00  -1.02177555599336E-11
     -1.38718118914287E-22  -3.35165710269115E-10  -3.45383465829188E-10  -3.06966238526875E-18
      1.49963528312975E-08
      0.00000000000000E+00   7.01693792265504E-14   0.00000000000000E+00   1.53178102579126E-14  -4.79546481919288E-23
     -7.02079642643694E-11  -7.01926464541594E-11  -1.29718599579494E-18  -4.73519370107939E-03  -4.73519370156992E-03
      0.00000000000000E+00   0.00000000000000E+00   4.90530383087499E-10   0.00000000000000E+00   4.90530383087499E-10
      4.39062052443985E-18  -2.99720048656928E-01  -2.99587617566601E-01   0.00000000000000E+00  -1.54816885143072E-11
     -1.40187172477719E-22  -4.04856048118909E-10  -4.20337736633356E-10  -3.09343452864491E-18
      1.50000000000000E-08
      0.00000000000000E+00   6.97101555405128E-14   0.00000000000000E+00   1.16962495221003E-14  -4.79526585625139E-23
     -6.97268902302176E-11  -6.97151939807434E-11  -1.29723958410139E-18  -4.71411496203161E-03  -4.71411496253065E-03
      0.00000000000000E+00   0.00000000000000E+00   4.99042668138835E-10   0.00000000000000E+00   4.99042668138835E-10
      4.39244061724028E-18  -3.00521268968366E-01  -3.00386005193518E-01   0.00000000000000E+00  -1.64235443606421E-11
     -1.40299407421826E-22  -4.12903929797268E-10  -4.29327474158051E-10  -3.09520103313890E-18
}
